/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.server;

import java.util.Stack;
import uk.org.toot.audio.server.AudioClient;

public class SwitchedAudioClient
implements AudioClient {
    private AudioClient client;
    Stack<AudioClient> stack = new Stack();
    boolean attached = true;

    public synchronized void work(int size) {
        if (this.attached && this.client != null) {
            this.client.work(size);
        }
    }

    public void setEnabled(boolean enabled) {
        this.attachServer(enabled);
    }

    public synchronized void installClient(AudioClient m) {
        if (this.client != null) {
            this.client.setEnabled(false);
        }
        this.client = m;
        if (this.client != null) {
            this.client.setEnabled(true);
        }
        this.stack.push(this.client);
    }

    public synchronized void revertClient() {
        if (this.client != null) {
            this.client.setEnabled(false);
        }
        this.stack.pop();
        this.client = this.stack.peek();
        if (this.client != null) {
            this.client.setEnabled(true);
        }
    }

    public synchronized void attachServer(boolean yes) {
        if (yes == this.attached) {
            return;
        }
        this.attached = yes;
        if (this.attached) {
            if (this.client != null) {
                this.client.setEnabled(true);
            }
        } else if (this.client != null) {
            this.client.setEnabled(false);
        }
    }
}

