/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.org.toot.audio.server.AudioServer;
import uk.org.toot.audio.server.AudioServerConfiguration;
import uk.org.toot.audio.server.spi.AudioServerServiceProvider;
import uk.org.toot.service.ServicePrinter;
import uk.org.toot.service.ServiceVisitor;
import uk.org.toot.service.Services;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioServerServices
extends Services {
    private static List<AudioServerServiceProvider> providers = new ArrayList<AudioServerServiceProvider>();

    static {
        AudioServerServices.scan();
    }

    protected AudioServerServices() {
    }

    public static AudioServer createServer(String name) {
        for (AudioServerServiceProvider provider : providers) {
            AudioServer server = provider.createServer(name);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public static AudioServerConfiguration createServerConfiguration(AudioServer server) {
        for (AudioServerServiceProvider provider : providers) {
            AudioServerConfiguration serverProperties = provider.createServerConfiguration(server);
            if (serverProperties == null) continue;
            return serverProperties;
        }
        return null;
    }

    public static void scan() {
        Iterator<AudioServerServiceProvider> it = AudioServerServices.lookup(AudioServerServiceProvider.class);
        providers.clear();
        while (it.hasNext()) {
            providers.add(it.next());
        }
    }

    public static void accept(ServiceVisitor v, Class<?> clazz) {
        for (AudioServerServiceProvider provider : providers) {
            provider.accept(v, clazz);
        }
    }

    public static void printServiceDescriptors(Class<?> clazz) {
        AudioServerServices.accept(new ServicePrinter(), clazz);
    }

    public static void main(String[] args) {
        try {
            AudioServerServices.printServiceDescriptors(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

