/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer.automation;

import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.mixer.automation.AutomationControls;
import uk.org.toot.audio.mixer.automation.MixerControlsDynamicAutomation;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;

public abstract class MixerControlsConciseDynamicAutomation
extends MixerControlsDynamicAutomation {
    protected MixerControlsConciseDynamicAutomation(MixerControls controls) {
        super(controls);
    }

    protected void write(Control c) {
        if (c.isIndicator()) {
            return;
        }
        int value = c.getIntValue();
        if (value < 0) {
            return;
        }
        int controlId = c.getId();
        if (controlId < 0) {
            return;
        }
        AudioControls module = this.findModule(c);
        int providerId = module.getProviderId();
        int moduleId = module.getId();
        int instanceIndex = module.getInstanceIndex();
        AudioControlsChain strip = (AudioControlsChain)module.getParent();
        AutomationControls ac = strip.find(AutomationControls.class);
        if (ac == null || !ac.canWrite()) {
            return;
        }
        this.write(strip.getName(), providerId, moduleId, instanceIndex, controlId, value);
    }

    protected boolean canRead(AudioControlsChain strip) {
        AutomationControls autoc = strip.find(AutomationControls.class);
        return autoc == null || autoc.canRead();
    }

    protected void read(String name, int providerId, int moduleId, int instanceIndex, int controlId, int value) {
        AudioControlsChain strip = this.getStrip(name);
        if (strip == null) {
            return;
        }
        if (!this.canRead(strip)) {
            return;
        }
        Control c = this.findControl(strip, providerId, moduleId, instanceIndex, controlId);
        if (c == null || c.getIntValue() == value) {
            return;
        }
        super.read(c, value);
    }

    protected abstract void write(String var1, int var2, int var3, int var4, int var5, int var6);

    protected AudioControlsChain getStrip(String name) {
        AudioControlsChain cc = this.mixerControls.getStripControls(name);
        if (!(cc instanceof AudioControlsChain)) {
            return null;
        }
        return cc;
    }

    protected Control findControl(AudioControlsChain strip, int providerId, int moduleId, int instanceIndex, int controlId) {
        CompoundControl module = strip.find(providerId, moduleId, instanceIndex);
        if (module == null) {
            return null;
        }
        return module.deepFind(controlId);
    }

    protected AudioControls findModule(Control c) {
        CompoundControl cc = c.getParent();
        while (!(cc.getParent() instanceof AudioControlsChain)) {
            cc = cc.getParent();
        }
        return (AudioControls)cc;
    }
}

