/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.mixer.BusControls;
import uk.org.toot.audio.mixer.MixerControlsFactory;
import uk.org.toot.audio.mixer.MixerControlsSnapshotAutomation;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;
import uk.org.toot.localisation.Localisation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixerControls
extends CompoundControl {
    private boolean canAddBusses = true;
    private BusControls mainBusControls;
    private List<BusControls> fxBusControls = new ArrayList<BusControls>();
    private List<BusControls> auxBusControls = new ArrayList<BusControls>();
    private MixerControlsSnapshotAutomation snapshotAutomation;
    private static String[] opNames = new String[]{"n/a", "Add", "Remove"};

    public MixerControls(String name) {
        this(name, Localisation.getString("Main"), ChannelFormat.STEREO);
    }

    public MixerControls(String name, String mainBusName, ChannelFormat channelFormat) {
        super(1, name);
        this.mainBusControls = new BusControls(127, mainBusName, channelFormat);
    }

    @Override
    public int getProviderId() {
        return 1;
    }

    public BusControls createFxBusControls(String name, ChannelFormat format) {
        if (!this.canAddBusses) {
            throw new IllegalStateException("Can't add busses after adding strips");
        }
        ChannelFormat mainFormat = this.mainBusControls.getChannelFormat();
        if (format == null) {
            format = mainFormat;
        } else if (format.getCount() > mainFormat.getCount()) {
            format = mainFormat;
            System.err.println(String.valueOf(name) + " Bus limited to Main Bus channel format");
        }
        BusControls busControls = new BusControls(125, name, format);
        this.fxBusControls.add(busControls);
        return busControls;
    }

    public BusControls createAuxBusControls(String name, ChannelFormat format) {
        if (!this.canAddBusses) {
            throw new IllegalStateException("Can't add busses after adding strips");
        }
        BusControls busControls = new BusControls(126, name, format);
        this.auxBusControls.add(busControls);
        return busControls;
    }

    public BusControls getBusControls(String name) {
        if (name.startsWith(this.mainBusControls.getName())) {
            return this.mainBusControls;
        }
        for (BusControls busControls : this.fxBusControls) {
            if (!name.startsWith(busControls.getName())) continue;
            return busControls;
        }
        for (BusControls busControls : this.auxBusControls) {
            if (!name.startsWith(busControls.getName())) continue;
            return busControls;
        }
        System.err.println(String.valueOf(name) + " not found");
        return null;
    }

    public BusControls getMainBusControls() {
        return this.mainBusControls;
    }

    public List<BusControls> getFxBusControls() {
        return Collections.unmodifiableList(this.fxBusControls);
    }

    public List<BusControls> getAuxBusControls() {
        return Collections.unmodifiableList(this.auxBusControls);
    }

    public AudioControlsChain createStripControls(int id, int index, String name) {
        return this.createStripControls(id, index, name, true, ChannelFormat.STEREO);
    }

    public AudioControlsChain createStripControls(int id, int index, String name, ChannelFormat constraintFormat) {
        return this.createStripControls(id, index, name, true, constraintFormat);
    }

    public AudioControlsChain createStripControls(int id, int index, String name, boolean hasMixControls, ChannelFormat constraintFormat) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (this.getStripControls(name) != null) {
            throw new IllegalArgumentException(String.valueOf(name) + " already exists");
        }
        AudioControlsChain chain = new AudioControlsChain(id, index, name, constraintFormat);
        MixerControlsFactory.addMixControls(this, chain, hasMixControls);
        this.addStripControls(chain);
        return chain;
    }

    public void addStripControls(CompoundControl cc) {
        this.canAddBusses = false;
        this.add(cc);
        this.setChanged();
        this.notifyObservers(new Mutation(1, cc));
    }

    public void removeStripControls(CompoundControl cc) {
        this.remove(cc);
        this.setChanged();
        this.notifyObservers(new Mutation(2, cc));
    }

    public void removeStripControls(String name) {
        AudioControlsChain cc = this.getStripControls(name);
        if (cc != null) {
            this.removeStripControls(cc);
        }
    }

    public void moveStripControls(String name, String beforeName) {
        AudioControlsChain cc = this.getStripControls(name);
        AudioControlsChain bc = this.getStripControls(beforeName);
        if (cc != null && bc != null) {
            this.remove(cc);
            int bi = this.controls.indexOf(bc);
            this.controls.add(bi, cc);
            this.setChanged();
            this.notifyObservers(null);
        }
    }

    public AudioControlsChain getStripControls(String name) {
        for (Control control : this.getControls()) {
            if (!control.getName().equals(name)) continue;
            return (AudioControlsChain)control;
        }
        return null;
    }

    public AudioControlsChain getStripControls(int id, int index) {
        for (Control c : this.getControls()) {
            if (c.getId() != id || ((AudioControlsChain)c).getInstanceIndex() != index) continue;
            return (AudioControlsChain)c;
        }
        return null;
    }

    public MixerControlsSnapshotAutomation getSnapshotAutomation() {
        return this.snapshotAutomation;
    }

    public void setSnapshotAutomation(MixerControlsSnapshotAutomation automation) {
        this.snapshotAutomation = automation;
    }

    public static class Mutation {
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        private int operation;
        private CompoundControl control;

        public Mutation(int operation, CompoundControl control) {
            this.operation = operation;
            this.control = control;
        }

        public int getOperation() {
            return this.operation;
        }

        public CompoundControl getControl() {
            return this.control;
        }

        public String toString() {
            return String.valueOf(opNames[this.operation]) + " " + this.control.getName();
        }
    }
}

