/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import java.awt.Color;
import java.util.Observable;
import java.util.Observer;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.meter.MeterControls;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.localisation.Localisation;

public class BusControls
extends AudioControls
implements Observer {
    private SoloIndicator soloIndicator;
    private MeterControls meterControls;
    private int soloCount = 0;
    private ChannelFormat channelFormat;

    public BusControls(int id, String name, ChannelFormat format) {
        super(id, name);
        this.channelFormat = format;
        this.soloIndicator = new SoloIndicator();
        this.meterControls = new MeterControls(this.channelFormat, "Meter");
        this.add(this.meterControls);
    }

    public SoloIndicator getSoloIndicator() {
        return this.soloIndicator;
    }

    public MeterControls getMeterControls() {
        return this.meterControls;
    }

    public boolean hasSolo() {
        return this.soloCount > 0;
    }

    public ChannelFormat getChannelFormat() {
        return this.channelFormat;
    }

    public void update(Observable obs, Object arg) {
        BooleanControl c;
        if (obs instanceof BooleanControl && (c = (BooleanControl)obs).getName().equals(Localisation.getString("Solo"))) {
            this.soloCount += c.getValue() ? 1 : -1;
            this.soloIndicator.setValue(this.hasSolo());
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + " Bus";
    }

    public static class SoloIndicator
    extends BooleanControl {
        public SoloIndicator() {
            super(-3, Localisation.getString("Solo"), false);
            this.indicator = true;
            this.setAnnotation("S");
            this.setStateColor(true, Color.green);
        }
    }
}

