/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.meter;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.Control;
import uk.org.toot.control.EnumControl;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LinearLaw;
import uk.org.toot.localisation.Localisation;

public class MeterControls
extends AudioControls {
    public static final int METER = 100;
    public static final int METER_TYPE = 2;
    public static final int METER_RESET = 3;
    public static final int METER_OVERS = 4;
    public static final int METER_INDICATOR = 5;
    public static final int METER_MIN_DB = 6;
    private static LinearLaw meterLaw = new LinearLaw(-60.0f, 20.0f, "dB");
    private ChannelFormat channelFormat;
    private ChannelState[] channelState;
    private OverIndicator overIndicator;
    private TypeControl typeControl;
    private MeterIndicator meterIndicator;
    private MindBControl mindBControl;
    private float peakRelease = 0.005f;
    private float averageSmooth = 0.038f;
    private static double PEAK_K_PER_MS = Math.log(0.05) / 3000.0;
    private static double AV_K_PER_MS = Math.log(0.01) / 600.0;

    public MeterControls(ChannelFormat format, String name) {
        super(100, name);
        this.channelFormat = format;
        int nchannels = this.channelFormat.getCount();
        this.channelState = new ChannelState[nchannels];
        int i = 0;
        while (i < nchannels) {
            this.channelState[i] = new ChannelState();
            ++i;
        }
        this.add(new ResetControl());
        this.overIndicator = new OverIndicator();
        this.add(this.overIndicator);
        this.typeControl = new TypeControl();
        this.add(this.typeControl);
        this.meterIndicator = new MeterIndicator(name);
        this.add(this.meterIndicator);
        this.mindBControl = new MindBControl();
        this.add(this.mindBControl);
    }

    public boolean isAlwaysVertical() {
        return true;
    }

    public MeterIndicator getMeterIndicator() {
        return this.meterIndicator;
    }

    public float getMaxdB() {
        return this.typeControl.getMaxdB();
    }

    public float getMindB() {
        return this.mindBControl.getMindB();
    }

    public ChannelFormat getChannelFormat() {
        return this.channelFormat;
    }

    protected boolean invalidChannel(int chan) {
        return chan < 0 || chan >= this.channelFormat.getCount();
    }

    public ChannelState getState(int chan) {
        if (this.invalidChannel(chan)) {
            return null;
        }
        return this.channelState[chan];
    }

    public void resetOvers() {
        int c = 0;
        while (c < this.channelFormat.getCount()) {
            this.channelState[c].overs = 0;
            ++c;
        }
        this.overIndicator.setChanged();
        this.overIndicator.notifyObservers();
    }

    public void resetMaxima() {
        int c = 0;
        while (c < this.channelFormat.getCount()) {
            this.channelState[c].maxPeak = this.channelState[c].peak;
            this.channelState[c].maxAverage = this.channelState[c].average;
            ++c;
        }
    }

    public void addOvers(int chan, int overs) {
        if (this.invalidChannel(chan) || overs == 0) {
            return;
        }
        this.channelState[chan].overs += overs;
        this.overIndicator.setChanged();
        this.overIndicator.notifyObservers();
    }

    public void setPeak(int chan, float peak) {
        if (this.invalidChannel(chan)) {
            return;
        }
        ChannelState state = this.channelState[chan];
        state.peak = peak > state.peak ? peak : (state.peak += this.peakRelease * (peak - state.peak));
        if (state.peak > state.maxPeak) {
            state.maxPeak = state.peak;
        }
    }

    public void setAverage(int chan, float average) {
        if (this.invalidChannel(chan)) {
            return;
        }
        ChannelState state = this.channelState[chan];
        state.average += this.averageSmooth * (average - state.average);
        if (state.average > state.maxAverage) {
            state.maxAverage = state.average;
        }
    }

    public void setUpdateTime(float ms) {
        this.peakRelease = (float)(1.0 - Math.exp((double)ms * PEAK_K_PER_MS));
        this.averageSmooth = (float)(1.0 - Math.exp((double)ms * AV_K_PER_MS));
    }

    public static class ChannelState {
        public int overs;
        public float maxPeak;
        public float peak;
        public float maxAverage;
        public float average;
    }

    public static class TypeControl
    extends EnumControl {
        private List<String> values = new ArrayList<String>();
        private float[] floatValues;

        public TypeControl() {
            super(2, "Type", "K-20/RMS");
            this.values.add("K-20/RMS");
            this.values.add("K-14/RMS");
            this.values.add("K-12/RMS");
            this.floatValues = new float[this.values.size()];
            int i = 0;
            while (i < this.values.size()) {
                this.floatValues[i] = Float.valueOf(this.values.get(i).substring(2, 4)).floatValue();
                ++i;
            }
        }

        public List getValues() {
            return this.values;
        }

        public float getMaxdB() {
            int i = this.values.indexOf(this.getValue());
            return this.floatValues[i];
        }

        public boolean isWidthLimited() {
            return false;
        }
    }

    public class ResetControl
    extends BooleanControl {
        public ResetControl() {
            super(3, Localisation.getString("Reset"), false, true);
        }

        public void momentaryAction() {
            MeterControls.this.resetOvers();
            MeterControls.this.resetMaxima();
        }

        public boolean isWidthLimited() {
            return false;
        }
    }

    public static class OverIndicator
    extends Control {
        public OverIndicator() {
            super(4, "");
        }

        public void setChanged() {
            super.setChanged();
        }
    }

    public static class MindBControl
    extends EnumControl {
        private List<String> values = new ArrayList<String>();
        private float[] floatValues;

        public MindBControl() {
            super(6, "Min", "-60");
            this.values.add("-12");
            this.values.add("-20");
            this.values.add("-40");
            this.values.add("-60");
            this.values.add("-80");
            this.values.add("-100");
            this.values.add("-120");
            this.floatValues = new float[this.values.size()];
            int i = 0;
            while (i < this.values.size()) {
                this.floatValues[i] = Float.valueOf(this.values.get(i)).floatValue();
                ++i;
            }
        }

        public List getValues() {
            return this.values;
        }

        public float getMindB() {
            int i = this.values.indexOf(this.getValue());
            return this.floatValues[i];
        }

        public boolean isWidthLimited() {
            return false;
        }
    }

    public static class MeterIndicator
    extends FloatControl {
        public MeterIndicator(String name) {
            super(5, name, meterLaw, 0.5f, -100.0f);
            this.indicator = true;
        }
    }
}

