/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.filter;

import uk.org.toot.audio.filter.AbstractFilterDesign;
import uk.org.toot.audio.filter.FilterSpecification;

public class FIRDesign
extends AbstractFilterDesign {
    private int order = -1;
    private float transitionBandwidth;
    private float attenuation = -60.0f;
    private float alpha;
    private float[] a;

    public FIRDesign(FilterSpecification spec) {
        super(spec);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public float getTransitionBandwidth() {
        return this.transitionBandwidth;
    }

    public void setTransitionBandwidth(float transitionBandwidth) {
        this.transitionBandwidth = transitionBandwidth;
    }

    public float getAttenuation() {
        return this.attenuation;
    }

    public void setAttenuation(float attenuation) {
        this.attenuation = attenuation;
    }

    public void design(int sampleRate) {
        float fNyquist = (float)sampleRate / 2.0f;
        float frequency = this.spec.getFrequency();
        if (this.order < 1) {
            this.order = this.estimatedOrder(fNyquist);
        }
        if (this.getAttenuation() >= 50.0f) {
            this.alpha = 0.1102f * (this.getAttenuation() - 8.7f);
        } else if (this.getAttenuation() > 21.0f) {
            this.alpha = 0.5842f * (float)Math.exp(0.4f * (float)Math.log(this.getAttenuation() - 21.0f)) + 0.07886f * (this.getAttenuation() - 21.0f);
        }
        if (this.getAttenuation() <= 21.0f) {
            this.alpha = 0.0f;
        }
        float I0alpha = this.I0(this.alpha);
        int m = this.order / 2;
        float[] win = new float[m + 1];
        int n = 1;
        while (n <= m) {
            win[n] = this.I0(this.alpha * (float)Math.sqrt(1.0f - this.sqr((float)n / (float)m))) / I0alpha;
            ++n;
        }
        float ft = this.getTransitionBandwidth();
        float w0 = 0.0f;
        float w1 = 0.0f;
        switch (this.spec.getClassicType()) {
            case LPF: {
                w0 = 0.0f;
                w1 = (float)Math.PI * (frequency + 0.5f * ft) / fNyquist;
                break;
            }
            case HPF: {
                w0 = (float)Math.PI;
                w1 = (float)Math.PI * (1.0f - (frequency - 0.5f * ft) / fNyquist);
                break;
            }
            case BPF: {
                w0 = (float)Math.PI * frequency / fNyquist;
                float fb = frequency / 4.0f;
                w1 = 1.5707964f * (fb + ft) / fNyquist;
            }
        }
        this.a = new float[this.order + 1];
        this.a[0] = w1 / (float)Math.PI;
        int n2 = 1;
        while (n2 <= m) {
            this.a[n2] = (float)Math.sin((float)n2 * w1) * (float)Math.cos((float)n2 * w0) * win[n2] / ((float)n2 * (float)Math.PI);
            ++n2;
        }
        n2 = m + 1;
        while (n2 <= this.order) {
            this.a[n2] = this.a[n2 - m];
            ++n2;
        }
        n2 = 0;
        while (n2 <= m - 1) {
            this.a[n2] = this.a[this.order - n2];
            ++n2;
        }
        this.a[m] = w1 / (float)Math.PI;
    }

    protected int estimatedOrder(float fNyquist) {
        int o = 2 * (int)(((double)this.getAttenuation() - 7.95) / (14.36 * (double)this.getTransitionBandwidth() / (double)fNyquist) + 1.0);
        return o;
    }

    protected float I0(float x) {
        float x2;
        float eps = 1.0E-6f;
        float fact = 1.0f;
        float p = x2 = 0.5f * x;
        float t = p * p;
        float s = 1.0f + t;
        int k = 2;
        while (t > eps) {
            t = this.sqr((p *= x2) / (fact *= (float)k));
            s += t;
            ++k;
        }
        return s;
    }

    protected float sqr(float x) {
        return x * x;
    }

    public float[] getCoefficients() {
        return this.a;
    }
}

