/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.filter;

import uk.org.toot.audio.core.FloatDenormals;
import uk.org.toot.audio.filter.AbstractFilter;
import uk.org.toot.audio.filter.BiQuadDesign;
import uk.org.toot.audio.filter.Filter;
import uk.org.toot.audio.filter.FilterDesign;
import uk.org.toot.audio.filter.FilterSpecification;

public class BiQuadFilter
extends AbstractFilter {
    private double a0;
    private double a1;
    private double a2;
    private double a3;
    private double a4;

    public BiQuadFilter(FilterSpecification spec) {
        super(spec);
    }

    public void filter(float[] buffer, float[] mixBuffer, int length, int chan, boolean doMix) {
        BiQuadState s = (BiQuadState)this.getState(chan);
        int index = 0;
        while (index < length) {
            float y;
            float sample = buffer[index];
            if (FloatDenormals.isDenormal(sample)) {
                sample = 0.0f;
            }
            if (FloatDenormals.isDenormal(y = (float)(this.a0 * (double)sample + this.a1 * (double)s.x1 + this.a2 * (double)s.x2 - this.a3 * (double)s.y1 - this.a4 * (double)s.y2))) {
                y = 0.0f;
            }
            s.x2 = s.x1;
            s.x1 = sample;
            s.y2 = s.y1;
            s.y1 = y;
            if (!doMix) {
                mixBuffer[index] = y;
            } else {
                int n = index;
                mixBuffer[n] = mixBuffer[n] + this.amplitudeAdj * y;
            }
            ++index;
        }
    }

    protected void updateFilterCoefficients() {
        BiQuadDesign d = (BiQuadDesign)this.getDesign();
        this.a0 = d.a0;
        this.a1 = d.a1;
        this.a2 = d.a2;
        this.a3 = d.a3;
        this.a4 = d.a4;
    }

    protected FilterDesign createDesign(FilterSpecification spec) {
        return new BiQuadDesign(spec);
    }

    protected Filter.State createState() {
        return new BiQuadState();
    }

    private static class BiQuadState
    implements Filter.State {
        public float x1;
        public float x2;
        public float y1;
        public float y2;

        public BiQuadState() {
            this.clear();
        }

        public void clear() {
            this.x1 = 0.0f;
            this.x2 = 0.0f;
            this.y1 = 0.0f;
            this.y2 = 0.0f;
        }
    }
}

