/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.filter;

import java.util.Observable;
import java.util.Observer;
import uk.org.toot.audio.filter.Filter;
import uk.org.toot.audio.filter.FilterDesign;
import uk.org.toot.audio.filter.FilterSpecification;

public abstract class AbstractFilter
implements Filter {
    private FilterDesign design = null;
    private Observer specObserver = null;
    private boolean doUpdate = true;
    private static final int MAX_CHANNELS = 2;
    private Filter.State[] states = new Filter.State[2];
    protected float amplitudeAdj = 0.0f;
    protected int sampleRate = -1;

    public AbstractFilter(FilterSpecification spec) {
        this.design = this.createDesign(spec);
        this.specObserver = new Observer(){

            public void update(Observable obs, Object obj) {
                if (AbstractFilter.this.sampleRate < 1) {
                    return;
                }
                AbstractFilter.this.design.design(AbstractFilter.this.sampleRate);
                AbstractFilter.this.doUpdate = true;
            }
        };
    }

    public void open() {
        this.getDesign().getFilterSpecification().addObserver(this.specObserver);
    }

    public void close() {
        this.getDesign().getFilterSpecification().deleteObserver(this.specObserver);
    }

    public FilterDesign getDesign() {
        return this.design;
    }

    public abstract void filter(float[] var1, float[] var2, int var3, int var4, boolean var5);

    public void clear() {
        int i = 0;
        while (i < 2) {
            if (this.states[i] != null) {
                this.states[i].clear();
            }
            ++i;
        }
    }

    protected Filter.State getState(int chan) {
        if (chan >= 2 || chan < 0) {
            return null;
        }
        if (this.doUpdate) {
            this.updateFilterCoefficients();
            this.doUpdate = false;
        }
        this.amplitudeAdj = this.design.getFilterSpecification().getLevelFactor() - 1.0f;
        if (this.states[chan] == null) {
            this.states[chan] = this.createState();
        }
        return this.states[chan];
    }

    public void setSampleRate(int rate) {
        this.sampleRate = rate;
        this.design.design(rate);
        this.doUpdate = true;
    }

    protected abstract FilterDesign createDesign(FilterSpecification var1);

    protected abstract Filter.State createState();

    protected abstract void updateFilterCoefficients();
}

