/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.fader;

import java.util.Arrays;
import uk.org.toot.control.ControlLaw;

public class FaderLaw
implements ControlLaw {
    public static final FaderLaw SEMI_LOG = new FaderLaw(1024, -10.0f, 10.0f, 0.33f);
    public static final FaderLaw LOG = new FaderLaw(1024, -20.0f, 15.0f, 0.2f);
    public static final FaderLaw BROADCAST = new FaderLaw(1024, -30.0f, 15.0f, 0.125f);
    private int resolution;
    private float halfdB;
    private float maxdB;
    private float attenuationCutoffFactor;
    private float[] floatValues;
    public static float ATTENUATION_CUTOFF = 100.0f;

    protected FaderLaw(int resolution, float halfdB, float maxdB, float attenuationCutoffFactor) {
        this.resolution = resolution;
        this.halfdB = halfdB;
        this.maxdB = maxdB;
        this.attenuationCutoffFactor = attenuationCutoffFactor;
    }

    public int getResolution() {
        return this.resolution;
    }

    public float getMaximum() {
        return this.maxdB;
    }

    public float getMinimum() {
        return -ATTENUATION_CUTOFF;
    }

    public float getMaxdB() {
        return this.maxdB;
    }

    public String getUnits() {
        return "dB";
    }

    public int intValue(float v) {
        if (this.floatValues == null) {
            this.floatValues = this.createFloatValues();
        }
        if (v <= this.floatValues[0]) {
            return 0;
        }
        if (v >= this.floatValues[this.resolution - 1]) {
            return this.resolution - 1;
        }
        int ret = Arrays.binarySearch(this.floatValues, v);
        if (ret >= 0) {
            return ret;
        }
        return -(++ret);
    }

    public float userValue(int v) {
        if (this.floatValues == null) {
            this.floatValues = this.createFloatValues();
        }
        if (v < 0) {
            return this.floatValues[0];
        }
        if (v > this.resolution - 1) {
            return this.floatValues[this.resolution - 1];
        }
        return this.floatValues[v];
    }

    private float[] createFloatValues() {
        float[] vals = new float[this.resolution];
        int i = 0;
        while (i < this.resolution) {
            vals[i] = this.calculateFloatValue(i);
            ++i;
        }
        return vals;
    }

    protected float calculateFloatValue(int v) {
        float val = (float)v / (float)(this.resolution - 1);
        val = this.maxdB + 2.0f * this.halfdB * (1.0f - val);
        float linZerodB = this.maxdB + 2.0f * this.halfdB;
        int cutoff = (int)(this.attenuationCutoffFactor * (float)(this.resolution - 1));
        if (v < cutoff) {
            float attenFactor = (float)(cutoff - v) / (float)cutoff;
            attenFactor *= attenFactor;
            val -= (ATTENUATION_CUTOFF + linZerodB) * attenFactor;
        }
        return val;
    }
}

