/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.delay.ModulatedDelayProcess;
import uk.org.toot.audio.delay.StereoModulatedDelayVariables;

public class StereoModulatedDelayProcess
extends ModulatedDelayProcess {
    private StereoModulatedDelayVariables vars;
    private float modulatorPhaseRight;

    public StereoModulatedDelayProcess(StereoModulatedDelayVariables vars) {
        super(vars);
        this.vars = vars;
    }

    public int processAudio(AudioBuffer buffer) {
        if (buffer.getChannelCount() == 1) {
            buffer.convertTo(ChannelFormat.STEREO);
        }
        return super.processAudio(buffer);
    }

    protected void buildModulatorMap(AudioBuffer buffer) {
        int nc = buffer.getChannelCount();
        int ch = 0;
        while (ch < nc) {
            this.modulatorMap[ch] = this.format.isLeft(ch) ? 0 : (this.format.isRight(ch) ? 1 : -1);
            ++ch;
        }
    }

    protected void incrementModulators(float timeDelta) {
        super.incrementModulators(timeDelta);
        this.modulatorPhaseRight = this.modulatorPhase + this.vars.getPhaseRadians();
        if ((double)this.modulatorPhaseRight > Math.PI) {
            this.modulatorPhaseRight = (float)((double)this.modulatorPhaseRight - Math.PI * 2);
        }
    }

    protected float modulation(int chan) {
        float mod;
        float phase;
        if (this.modulatorMap[chan] == 0) {
            phase = this.modulatorPhase;
        } else if (this.modulatorMap[chan] == 1) {
            phase = this.modulatorPhaseRight;
        } else {
            return 0.0f;
        }
        int shape = this.vars.getLFOShape();
        float f = mod = shape == 0 ? this.sine(phase) : this.triangle(phase);
        if (mod < -1.0f) {
            mod = -1.0f;
        } else if (mod > 1.0f) {
            mod = 1.0f;
        }
        return mod;
    }
}

