/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import java.awt.Color;
import java.util.List;
import uk.org.toot.audio.delay.AbstractDelayControls;
import uk.org.toot.audio.delay.DelayTap;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.ControlLaw;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LinearLaw;

public class RoomSimulatorControls
extends AbstractDelayControls {
    private static final ControlLaw LENGTH_LAW = new LinearLaw(2.0f, 200.0f, "m");
    private static final ControlLaw RELATIVE_SIZE_LAW = new LinearLaw(0.2f, 5.0f, "");
    private static final int LENGTH_ID = 1;
    private static final int WIDTH_ID = 2;
    private static final int HEIGHT_ID = 3;
    private List<DelayTap>[] taps;
    private FloatControl lengthControl;
    private FloatControl widthControl;
    private FloatControl heightControl;

    public RoomSimulatorControls() {
        super(19, "Room Simulator");
        CompoundControl.ControlColumn roomg = new CompoundControl.ControlColumn();
        this.lengthControl = new FloatControl(1, "Length", LENGTH_LAW, 0.1f, 20.0f);
        this.lengthControl.setInsertColor(Color.red.darker());
        roomg.add(this.lengthControl);
        this.widthControl = new FloatControl(2, "Width", RELATIVE_SIZE_LAW, 0.1f, 1.0f);
        this.widthControl.setInsertColor(Color.magenta.darker());
        roomg.add(this.widthControl);
        this.heightControl = new FloatControl(3, "Height", RELATIVE_SIZE_LAW, 0.1f, 1.0f);
        this.heightControl.setInsertColor(Color.magenta.darker());
        roomg.add(this.heightControl);
        this.add(roomg);
        this.add(this.createCommonControlColumn(false));
    }

    public float getLength() {
        return this.lengthControl.getValue();
    }

    public float getWidth() {
        return this.getRelativeWidth() * this.getLength();
    }

    public float getHeight() {
        return this.getRelativeHeight() * this.getLength();
    }

    public float getRelativeWidth() {
        return this.widthControl.getValue();
    }

    public float getRelativeHeight() {
        return this.heightControl.getValue();
    }

    public boolean canBypass() {
        return true;
    }
}

