/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import uk.org.toot.audio.delay.AbstractDelayControls;
import uk.org.toot.audio.delay.DelayTap;
import uk.org.toot.audio.delay.MultiTapDelayControls;
import uk.org.toot.audio.delay.MultiTapDelayVariables;
import uk.org.toot.control.ControlLaw;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LogLaw;
import uk.org.toot.localisation.Localisation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTapDelayStereoControls
extends AbstractDelayControls
implements MultiTapDelayVariables {
    private List<MultiTapDelayControls> perChannelControls;
    private float msMax;
    private static ControlLaw delayFactorLaw = new LogLaw(0.2f, 5.0f, "");
    private FloatControl delayFactorControl;

    public MultiTapDelayStereoControls() {
        this(3, 2000.0f);
    }

    public MultiTapDelayStereoControls(int ntaps, float ms) {
        super(18, Localisation.getString("Stereo.Multi.Tap.Delay"));
        this.msMax = ms;
        this.perChannelControls = new ArrayList<MultiTapDelayControls>();
        int a = 0;
        while (a < 2) {
            String name = a == 0 ? Localisation.getString("Left") : Localisation.getString("Right");
            MultiTapDelayControls c = new MultiTapDelayControls(a * 16, ntaps, this.msMax, name);
            this.add(c);
            this.perChannelControls.add(c);
            ++a;
        }
        this.delayFactorControl = new FloatControl(125, Localisation.getString("Delay"), delayFactorLaw, 0.01f, 1.0f);
        this.delayFactorControl.setInsertColor(Color.RED.darker());
        this.add(this.delayFactorControl);
        this.add(this.createCommonControlColumn(false));
    }

    @Override
    public float getMaxDelayMilliseconds() {
        return this.msMax;
    }

    @Override
    public boolean canBypass() {
        return true;
    }

    @Override
    public List<DelayTap> getTaps(int chan) {
        return this.perChannelControls.get(chan).getTaps();
    }

    @Override
    public int getChannelCount() {
        return 2;
    }

    @Override
    public float getDelayFactor() {
        return this.delayFactorControl.getValue();
    }
}

