/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.delay.DelayBuffer;
import uk.org.toot.audio.delay.DelayTap;
import uk.org.toot.audio.delay.MultiTapDelayVariables;

public class MultiTapDelayProcess
implements AudioProcess {
    private DelayBuffer delayBuffer;
    private DelayBuffer tappedBuffer;
    private final MultiTapDelayVariables vars;
    private boolean wasBypassed;

    public MultiTapDelayProcess(MultiTapDelayVariables vars) {
        this.vars = vars;
        this.wasBypassed = !vars.isBypassed();
    }

    public void open() {
    }

    public int processAudio(AudioBuffer buffer) {
        boolean bypassed = this.vars.isBypassed();
        if (bypassed) {
            if (!this.wasBypassed) {
                if (this.delayBuffer != null) {
                    this.delayBuffer.makeSilence();
                }
                this.wasBypassed = true;
            }
            return 0;
        }
        if (buffer.getChannelCount() < 2) {
            buffer.convertTo(ChannelFormat.STEREO);
        }
        float sampleRate = buffer.getSampleRate();
        int ns = buffer.getSampleCount();
        int nc = buffer.getChannelCount();
        float feedback = this.vars.getFeedback();
        float mix = this.vars.getMix();
        if (this.delayBuffer == null) {
            this.delayBuffer = new DelayBuffer(nc, this.msToSamples(this.vars.getMaxDelayMilliseconds(), sampleRate), sampleRate);
        } else {
            this.delayBuffer.conform(buffer);
        }
        if (this.tappedBuffer == null) {
            this.tappedBuffer = new DelayBuffer(nc, ns, sampleRate);
        } else {
            this.tappedBuffer.conform(buffer);
            if (this.tappedBuffer.getSampleCount() != ns) {
                this.tappedBuffer.changeSampleCount(ns, false);
            }
        }
        this.tappedBuffer.makeSilence();
        float delayFactor = this.vars.getDelayFactor();
        ChannelFormat format = buffer.getChannelFormat();
        int c = 0;
        while (c < nc) {
            block18: {
                int c2;
                block17: {
                    block16: {
                        if (!format.isLeft(c)) break block16;
                        c2 = ChannelFormat.STEREO.getLeft()[0];
                        break block17;
                    }
                    if (!format.isRight(c)) break block18;
                    c2 = ChannelFormat.STEREO.getRight()[0];
                }
                for (DelayTap tap : this.vars.getTaps(c2)) {
                    int delay;
                    float level = tap.getLevel();
                    if ((double)level < 0.001 || (delay = this.msToSamples(tap.getDelayMilliseconds() * delayFactor, sampleRate)) < ns) continue;
                    this.delayBuffer.tap(c, this.tappedBuffer, delay, level);
                }
            }
            ++c;
        }
        this.delayBuffer.append(buffer, this.tappedBuffer, feedback);
        c = 0;
        while (c < nc) {
            float[] samples = buffer.getChannel(c);
            float[] tapped = this.tappedBuffer.getChannel(c);
            int i = 0;
            while (i < ns) {
                int n = i;
                samples[n] = samples[n] + mix * tapped[i];
                ++i;
            }
            ++c;
        }
        this.wasBypassed = bypassed;
        return 0;
    }

    public void close() {
        this.delayBuffer = null;
        this.tappedBuffer = null;
    }

    protected int msToSamples(float ms, float sr) {
        return (int)(ms * sr / 1000.0f);
    }
}

