/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import java.awt.Color;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.delay.DelayTap;
import uk.org.toot.control.ControlLaw;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LinearLaw;
import uk.org.toot.localisation.Localisation;

public class DelayTapControls
extends AudioControls
implements DelayTap {
    private static final ControlLaw levelLaw = new LinearLaw(0.0f, 1.0f, "");
    private FloatControl delayControl;
    private FloatControl levelControl;

    public DelayTapControls(int id, float msMax) {
        super(id, "");
        LinearLaw delayLaw = new LinearLaw(0.1f, msMax, "ms");
        this.delayControl = new FloatControl(id, Localisation.getString("Delay"), delayLaw, 0.1f, msMax / 4.0f);
        this.delayControl.setInsertColor(Color.red.darker());
        this.add(this.delayControl);
        this.levelControl = new FloatControl(id + 1, Localisation.getString("Level"), levelLaw, 0.01f, 0.0f);
        this.levelControl.setInsertColor(Color.black);
        this.add(this.levelControl);
    }

    public boolean isAlwaysVertical() {
        return true;
    }

    public float getDelayMilliseconds() {
        return this.delayControl.getValue();
    }

    public float getLevel() {
        return this.levelControl.getValue();
    }
}

