/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.delay.ImageSourceDesign;
import uk.org.toot.audio.delay.ModulatedDelayControls;
import uk.org.toot.audio.delay.ModulatedDelayProcess;
import uk.org.toot.audio.delay.ModulatedDelayVariables;
import uk.org.toot.audio.delay.MultiTapDelayProcess;
import uk.org.toot.audio.delay.MultiTapDelayStereoControls;
import uk.org.toot.audio.delay.MultiTapDelayVariables;
import uk.org.toot.audio.delay.RoomSimulatorControls;
import uk.org.toot.audio.delay.StereoModulatedDelayControls;
import uk.org.toot.audio.delay.StereoModulatedDelayProcess;
import uk.org.toot.audio.delay.StereoModulatedDelayVariables;
import uk.org.toot.audio.spi.TootAudioServiceProvider;
import uk.org.toot.localisation.Localisation;

public class DelayServiceProvider
extends TootAudioServiceProvider {
    public DelayServiceProvider() {
        super(Localisation.getString("Delay"), "0.1");
        String family = this.description;
        this.addControls(ModulatedDelayControls.class, 20, Localisation.getString("Modulated.Delay"), family, "0.1");
        this.addControls(StereoModulatedDelayControls.class, 17, Localisation.getString("Stereo.Modulated.Delay"), family, "0.1", ChannelFormat.STEREO);
        this.addControls(MultiTapDelayStereoControls.class, 18, Localisation.getString("Stereo.Multi.Tap.Delay"), family, "0.1", ChannelFormat.STEREO);
        this.add(ModulatedDelayProcess.class, Localisation.getString("Modulated.Delay"), family, "0.1");
        this.add(StereoModulatedDelayProcess.class, Localisation.getString("Stereo.Modulated.Delay"), family, "0.1");
        this.add(MultiTapDelayProcess.class, Localisation.getString("Multi.Tap.Delay"), family, "0.1");
    }

    public AudioProcess createProcessor(AudioControls c) {
        if (c instanceof StereoModulatedDelayVariables) {
            return new StereoModulatedDelayProcess((StereoModulatedDelayVariables)((Object)c));
        }
        if (c instanceof ModulatedDelayVariables) {
            return new ModulatedDelayProcess((ModulatedDelayVariables)((Object)c));
        }
        if (c instanceof MultiTapDelayVariables) {
            return new MultiTapDelayProcess((MultiTapDelayVariables)((Object)c));
        }
        if (c instanceof RoomSimulatorControls) {
            return new MultiTapDelayProcess(new ImageSourceDesign((RoomSimulatorControls)c));
        }
        return null;
    }
}

