/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.delay;

import java.awt.Color;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.ControlLaw;
import uk.org.toot.control.FloatControl;
import uk.org.toot.control.LinearLaw;
import uk.org.toot.localisation.Localisation;

public class AbstractDelayControls
extends AudioControls {
    private static final int FEEDBACK_INVERT_ID = 121;
    private static final int FEEDBACK_ID = 122;
    private static final int MIX_INVERT_ID = 123;
    private static final int MIX_ID = 124;
    protected static final int DELAY_FACTOR_ID = 125;
    protected static final ControlLaw UNITY_LIN_LAW = new LinearLaw(0.0f, 1.0f, "");
    private BooleanControl feedbackInvertControl;
    private FloatControl feedbackControl;
    private BooleanControl mixInvertControl;
    private FloatControl mixControl;

    public AbstractDelayControls(int id, String name) {
        super(id, name);
    }

    protected void addFeedbackInvertControl() {
        this.feedbackInvertControl = new BooleanControl(121, Localisation.getString("Invert"), false);
        this.feedbackInvertControl.setStateColor(true, Color.orange);
    }

    protected void addFeedbackControl() {
        this.feedbackControl = new FloatControl(122, Localisation.getString("Resonance"), UNITY_LIN_LAW, 0.01f, 0.0f);
        this.feedbackControl.setInsertColor(Color.orange);
    }

    protected void addMixInvertControl() {
        this.mixInvertControl = new BooleanControl(123, Localisation.getString("Invert"), false);
        this.mixInvertControl.setStateColor(true, Color.PINK);
    }

    protected void addMixControl() {
        this.mixControl = new MixControl();
    }

    protected CompoundControl.ControlColumn createCommonControlColumn(boolean withInverts) {
        CompoundControl.ControlColumn g = new CompoundControl.ControlColumn();
        if (withInverts) {
            this.addFeedbackInvertControl();
        }
        this.addFeedbackControl();
        if (withInverts) {
            this.addMixInvertControl();
        }
        this.addMixControl();
        if (this.feedbackInvertControl != null) {
            g.add(this.feedbackInvertControl);
        }
        if (this.feedbackControl != null) {
            g.add(this.feedbackControl);
        }
        if (this.mixInvertControl != null) {
            g.add(this.mixInvertControl);
        }
        if (this.mixControl != null) {
            g.add(this.mixControl);
        }
        return g;
    }

    public boolean isFeedbackInverted() {
        if (this.feedbackInvertControl == null) {
            return false;
        }
        return this.feedbackInvertControl.getValue();
    }

    public float getFeedback() {
        if (this.feedbackControl == null) {
            return 0.0f;
        }
        if (this.isFeedbackInverted()) {
            return -this.feedbackControl.getValue();
        }
        return this.feedbackControl.getValue();
    }

    public boolean isWetInverted() {
        if (this.mixInvertControl == null) {
            return false;
        }
        return this.mixInvertControl.getValue();
    }

    public float getMix() {
        if (this.mixControl == null) {
            return 1.0f;
        }
        return this.mixControl.getValue();
    }

    public static class MixControl
    extends FloatControl {
        private static final String[] presetNames = new String[]{Localisation.getString("Dry"), Localisation.getString("Wet")};

        public MixControl() {
            super(124, Localisation.getString("Mix"), UNITY_LIN_LAW, 0.01f, 0.5f);
            this.setInsertColor(Color.white);
        }

        public String[] getPresetNames() {
            return presetNames;
        }

        public void applyPreset(String name) {
            if (Localisation.getString("Dry").equals(name)) {
                this.setValue(0.0f);
            } else if (Localisation.getString("Wet").equals(name)) {
                this.setValue(1.0f);
            }
        }
    }
}

