/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.core;

public class FloatDenormals {
    public static final float THRESHOLD = 1.0E-15f;

    public static boolean isDenormal(float x) {
        return x != 0.0f && FloatDenormals.isDenormalOrZero(x);
    }

    public static boolean isDenormalOrZero(float x) {
        return Math.abs(x) < 1.0E-15f;
    }

    public static float zeroDenorm(float x) {
        return FloatDenormals.isDenormalOrZero(x) ? 0.0f : x;
    }

    public static void zeroDenorms(float[] array, int len) {
        int i = 0;
        while (i < len) {
            array[i] = FloatDenormals.zeroDenorm(array[i]);
            ++i;
        }
    }

    public static int countDenorms(float[] array, int len) {
        int count = 0;
        int i = 0;
        while (i < len) {
            if (FloatDenormals.isDenormal(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

