/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.spi.AudioServiceProvider;
import uk.org.toot.service.ServicePrinter;
import uk.org.toot.service.ServiceVisitor;
import uk.org.toot.service.Services;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioServices
extends Services {
    private static List<AudioServiceProvider> providers = new ArrayList<AudioServiceProvider>();

    static {
        AudioServices.scan();
    }

    protected AudioServices() {
    }

    public static String lookupModuleName(int providerId, int moduleId) {
        for (AudioServiceProvider provider : providers) {
            String name;
            if (provider.getProviderId() != providerId || (name = provider.lookupName(moduleId)) == null) continue;
            return name;
        }
        return null;
    }

    public static AudioControls createControls(String name) {
        for (AudioServiceProvider provider : providers) {
            AudioControls controls = provider.createControls(name);
            if (controls == null) continue;
            controls.providerId = provider.getProviderId();
            return controls;
        }
        return null;
    }

    public static AudioProcess createProcess(AudioControls controls) {
        for (AudioServiceProvider provider : providers) {
            AudioProcess process = provider.createProcessor(controls);
            if (process == null) continue;
            return process;
        }
        return null;
    }

    public static void scan() {
        Iterator<AudioServiceProvider> it = AudioServices.lookup(AudioServiceProvider.class);
        providers.clear();
        while (it.hasNext()) {
            providers.add(it.next());
        }
    }

    public static void accept(ServiceVisitor v, Class<?> clazz) {
        for (AudioServiceProvider provider : providers) {
            provider.accept(v, clazz);
        }
    }

    public static void printServiceDescriptors(Class<?> clazz) {
        AudioServices.accept(new ServicePrinter(), clazz);
    }

    public static void main(String[] args) {
        try {
            AudioServices.printServiceDescriptors(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

