/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.basic.stereoImage;

import uk.org.toot.audio.basic.stereoImage.StereoImageProcessVariables;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.core.SimpleAudioProcess;

public class StereoImageProcess
extends SimpleAudioProcess {
    private StereoImageProcessVariables vars;

    public StereoImageProcess(StereoImageProcessVariables variables) {
        this.vars = variables;
    }

    public int processAudio(AudioBuffer buffer) {
        int nsamples = buffer.getSampleCount();
        if (buffer.getChannelCount() < 2) {
            buffer.convertTo(ChannelFormat.STEREO);
        }
        float otherFactor = this.vars.getWidthFactor();
        boolean swap = this.vars.isLRSwapped();
        ChannelFormat format = buffer.getChannelFormat();
        int[] leftChans = format.getLeft();
        int[] rightChans = format.getRight();
        int pair = 0;
        while (pair < leftChans.length) {
            float[] left = buffer.getChannel(leftChans[pair]);
            float[] right = buffer.getChannel(rightChans[pair]);
            int i = 0;
            while (i < nsamples) {
                float tmp = left[i];
                int n = i;
                left[n] = left[n] + otherFactor * right[i];
                int n2 = i++;
                right[n2] = right[n2] + otherFactor * tmp;
            }
            if (swap) {
                buffer.swap(leftChans[pair], rightChans[pair]);
            }
            ++pair;
        }
        return 0;
    }
}

