/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;

public class Installer
extends JFrame {
    private String myClassName;
    static String MANIFEST = "META-INF/MANIFEST.MF";

    Installer() {
    }

    private String getJarFileName() {
        this.myClassName = String.valueOf(this.getClass().getName()) + ".class";
        URL urlJar = ClassLoader.getSystemResource(this.myClassName);
        String urlStr = urlJar.toString();
        int from = "jar:file:".length();
        int to = urlStr.indexOf("!/");
        return urlStr.substring(from, to);
    }

    public void extract(String zipfile) {
        block19: {
            File currentArchive = new File(zipfile);
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File("."));
            fc.setDialogType(0);
            fc.setDialogTitle("Select installation directory for " + currentArchive.getName());
            fc.setMultiSelectionEnabled(false);
            fc.setFileSelectionMode(1);
            if (fc.showDialog(this, "Select") != 0) {
                return;
            }
            File outputDir = fc.getSelectedFile();
            byte[] buf = new byte[1024];
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mma", Locale.getDefault());
            ProgressMonitor pm = null;
            boolean overwrite = false;
            ZipFile zf = null;
            FileOutputStream out = null;
            InputStream in = null;
            try {
                zf = new ZipFile(currentArchive);
                int size = zf.size();
                int extracted = 0;
                pm = new ProgressMonitor(this.getParent(), "Extracting files...", "starting", 0, size - 4);
                pm.setMillisToDecideToPopup(0);
                pm.setMillisToPopup(0);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                int i = 0;
                while (i < size) {
                    block20: {
                        int nRead;
                        File parent;
                        Date archiveTime;
                        File outFile;
                        block21: {
                            String pathname;
                            ZipEntry entry = entries.nextElement();
                            if (entry.isDirectory() || this.myClassName.equals(pathname = entry.getName()) || MANIFEST.equals(pathname.toUpperCase())) break block20;
                            ++extracted;
                            pm.setProgress(i);
                            pm.setNote(pathname);
                            if (pm.isCanceled()) {
                                return;
                            }
                            in = zf.getInputStream(entry);
                            outFile = new File(outputDir, pathname);
                            archiveTime = new Date(entry.getTime());
                            if (overwrite || !outFile.exists()) break block21;
                            Object[] options = new Object[]{"Yes", "Yes To All", "No"};
                            Date existTime = new Date(outFile.lastModified());
                            Long archiveLen = new Long(entry.getSize());
                            String msg = String.valueOf(outFile.getName()) + " already exists." + "\nExisting file: " + formatter.format(existTime) + ",  " + outFile.length() + " bytes" + "\nFile to install:" + formatter.format(archiveTime) + ",  " + archiveLen + " bytes" + "\n\nOverwrite this file?";
                            int result = JOptionPane.showOptionDialog(this, msg, "Warning", -1, 2, null, options, options[0]);
                            if (result == 2) break block20;
                            if (result == 1) {
                                overwrite = true;
                            }
                        }
                        if ((parent = new File(outFile.getParent())) != null && !parent.exists()) {
                            parent.mkdirs();
                        }
                        out = new FileOutputStream(outFile);
                        while ((nRead = in.read(buf, 0, buf.length)) > 0) {
                            out.write(buf, 0, nRead);
                        }
                        out.close();
                        outFile.setLastModified(archiveTime.getTime());
                    }
                    ++i;
                }
                pm.close();
                zf.close();
                this.getToolkit().beep();
                JOptionPane.showMessageDialog(this, "Installed " + extracted + " file" + (extracted > 1 ? "s" : "") + " to " + outputDir.getPath(), "Installer", 1);
            }
            catch (Exception e) {
                System.out.println(e);
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (in == null) break block19;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            String syslaf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(syslaf);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        Installer i = new Installer();
        String jarFileName = i.getJarFileName();
        i.extract(jarFileName);
        System.exit(0);
    }
}

