/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import com.frinika.global.FrinikaConfig;
import com.frinika.sequencer.model.audio.AudioReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Observable;
import uk.co.simphoney.audio.SpectrogramDataListener;
import uk.org.toot.audio.core.AudioBuffer;

public class WaveImage
extends Observable
implements SpectrogramDataListener {
    private static final long serialVersionUID = 1L;
    int nChannel;
    private Image thumbNailImage = null;
    private AudioReader gin = null;
    private ThumbNailRunnable thumbNailRunnable;
    private double frameToScreen;
    int height = 100;
    Dimension rect;

    WaveImage(AudioReader gin) {
        this.gin = gin;
    }

    public Dimension getPreferredSize() {
        if (this.rect == null) {
            return new Dimension(1000, this.height);
        }
        return this.rect;
    }

    private void reconstructThumbNail(Dimension rect) {
        if (this.thumbNailRunnable == null) {
            this.thumbNailRunnable = new ThumbNailRunnable();
            Thread t = new Thread(this.thumbNailRunnable);
            t.setPriority(1);
            this.thumbNailRunnable.setThread(t);
            t.start();
        }
        this.thumbNailRunnable.reconstruct(rect);
    }

    public void notifySizeChange(Dimension d) {
        d.height = this.height;
        this.reconstructThumbNail(d);
    }

    public void drawImage(Graphics2D g, int i, int j) {
        if (this.thumbNailImage == null) {
            return;
        }
        g.setColor(Color.RED);
        g.fillRect(i, j, this.thumbNailImage.getWidth(null), this.thumbNailImage.getHeight(null));
        g.setXORMode(Color.WHITE);
        g.drawImage(this.thumbNailImage, i, j, null);
        g.setPaintMode();
    }

    public int getWidth() {
        if (this.rect == null) {
            return 100;
        }
        return this.rect.width;
    }

    public int getHeight() {
        return this.height;
    }

    int frameToScreen(long frame) {
        return (int)(this.frameToScreen * (double)frame);
    }

    public int screenToFrame(int p) {
        return (int)((double)p / this.frameToScreen);
    }

    public void notifyMoreDataReady() {
    }

    class ThumbNailRunnable
    implements Runnable {
        Thread runThread;
        Graphics2D gg;

        ThumbNailRunnable() {
        }

        public void reconstruct(Dimension rect1) {
            WaveImage.this.rect = (Dimension)rect1.clone();
            if (this.runThread.isInterrupted()) {
                System.out.println(" Thunmb nail thread already interupted");
                return;
            }
            this.runThread.interrupt();
        }

        public void setThread(Thread t) {
            this.runThread = t;
        }

        synchronized boolean buildThumbNail() {
            if (WaveImage.this.rect.getWidth() == 0.0) {
                return true;
            }
            WaveImage.this.thumbNailImage = new BufferedImage(WaveImage.this.rect.width, WaveImage.this.rect.height, 12);
            this.gg = (Graphics2D)WaveImage.this.thumbNailImage.getGraphics();
            long nSamp = WaveImage.this.gin.getLengthInFrames();
            WaveImage.this.frameToScreen = (double)WaveImage.this.rect.width / (double)nSamp;
            try {
                WaveImage.this.gin.seekFrame(0L, false);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int nChannel = WaveImage.this.gin.getFormat().getChannels();
            long nFrame = WaveImage.this.gin.getLengthInFrames();
            int chunkSize = 1024;
            int nRead = 0;
            float valMax = 0.0f;
            float valMin = 0.0f;
            double scale = (double)WaveImage.this.rect.height / 2.0;
            this.gg.setColor(Color.white);
            int midY = WaveImage.this.rect.height / 2;
            int pix = 0;
            int ii = 0;
            AudioBuffer buff = new AudioBuffer("WaveThumbnail", nChannel, chunkSize, (float)FrinikaConfig.sampleRate);
            System.out.println(" chunkSize,nFrame =" + chunkSize + " " + nFrame);
            while ((long)nRead < nFrame) {
                if (this.runThread.isInterrupted()) {
                    System.out.println("Interupted .....");
                    return false;
                }
                int nn = chunkSize;
                buff.makeSilence();
                WaveImage.this.gin.processAudio(buff);
                nRead += chunkSize;
                float[] sampleLA = buff.getChannel(0);
                float[] sampleRA = nChannel == 2 ? buff.getChannel(1) : buff.getChannel(0);
                assert (buff.getSampleCount() == chunkSize);
                int i = 0;
                while (i < chunkSize) {
                    float sampleL = sampleLA[i];
                    float sampleR = sampleRA[i];
                    valMin = Math.min(Math.min(valMin, sampleL), sampleR);
                    valMax = Math.max(Math.max(valMax, sampleL), sampleR);
                    int pixNow = (int)((double)ii * WaveImage.this.frameToScreen);
                    if (pixNow > pix) {
                        this.gg.drawLine(pix, (int)((double)midY + (double)valMin * scale), pix, (int)((double)midY + (double)valMax * scale));
                        pix = pixNow;
                        valMin = 0.0f;
                        valMax = 0.0f;
                    }
                    ++i;
                    ++ii;
                }
            }
            WaveImage.this.setChanged();
            WaveImage.this.notifyObservers();
            System.out.println(" BUILD DONE" + WaveImage.this.rect);
            return true;
        }

        public Image getImage() {
            return WaveImage.this.thumbNailImage;
        }

        public synchronized void run() {
            assert (this.runThread == Thread.currentThread());
            block2: while (true) {
                try {
                    while (true) {
                        this.wait();
                    }
                }
                catch (InterruptedException e1) {
                    while (true) {
                        if (this.buildThumbNail()) continue block2;
                        Thread.interrupted();
                    }
                }
                break;
            }
        }
    }
}

