/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import uk.co.simphoney.audio.constantq.FreqToBin;

public class SpectrogramPanelOLD
extends JPanel {
    private static final long serialVersionUID = 1L;
    BufferedImage img;
    Graphics2D graphic;
    private int[] rgbarray;
    Dimension imageSize;
    Dimension size;
    int scaleX = 2;
    int scaleY = 4;
    private FreqToBin f2b;
    private double[] freq;
    private double[][] buffer;
    private double[][] pFreq;
    private boolean dirty = true;
    private double thresh;
    private double[][] dbuff;
    static final int nLevel = 256;
    static Color[] fcol = new Color[256];

    public SpectrogramPanelOLD() {
        for (int i = 0; i < 256; ++i) {
            SpectrogramPanelOLD.fcol[i] = new Color(255, 0, 0, i);
        }
        this.setDoubleBuffered(false);
    }

    void createGraphics(Dimension newSize) {
        this.imageSize = newSize;
        this.size = new Dimension(newSize.width * this.scaleX, newSize.height * this.scaleY);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        this.img = graphicsConfiguration.createCompatibleImage(this.imageSize.width, this.imageSize.height, 2);
        this.graphic = this.img.createGraphics();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dirty) {
            this.makeImage();
        }
        g.drawImage(this.img, 0, 0, this.size.width, this.size.height, 0, 0, this.imageSize.width, this.imageSize.height, this);
        if (this.thresh == 0.0) {
            return;
        }
        double f1 = 0.0;
        double v1 = 0.0;
        boolean active = false;
        Color c = new Color(255, 0, 0);
        int h = this.imageSize.height * this.scaleY;
        for (int j = 0; j < this.imageSize.height; ++j) {
            int bin = this.imageSize.height - j - 1;
            for (int i = 0; i < this.imageSize.width; ++i) {
                if (this.buffer[i][bin] > this.thresh) {
                    if (active) {
                        double f2 = this.f2b.getBin(this.pFreq[i][bin]);
                        double val = (this.buffer[i][bin] + v1) / 2.0;
                        int idx = (int)(255.0 * val);
                        if (idx > 255) {
                            idx = 255;
                        } else if (idx < 0) {
                            idx = 0;
                        }
                        g.setColor(fcol[idx]);
                        g.drawLine((i - 1) * this.scaleX, (int)((double)h - f1 * (double)this.scaleY - (double)(this.scaleY / 2)), i * this.scaleX, (int)((double)h - f2 * (double)this.scaleY - (double)(this.scaleY / 2)));
                        f1 = f2;
                        continue;
                    }
                    f1 = this.f2b.getBin(this.pFreq[i][bin]);
                    v1 = this.buffer[i][bin];
                    active = true;
                    continue;
                }
                active = false;
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public Dimension getMaximumSize() {
        return this.size;
    }

    public void setData(double[][] buffer, double[][] pFreq, double[] freq, double dt, FreqToBin f2b, double thresh, double[][] dbuff) {
        this.f2b = f2b;
        this.freq = freq;
        this.buffer = buffer;
        this.dbuff = dbuff;
        this.pFreq = pFreq;
        this.thresh = thresh;
        int w = buffer.length;
        int h = buffer[0].length;
        Dimension sizeNew = new Dimension(w, h);
        if (!sizeNew.equals(this.imageSize)) {
            this.createGraphics(sizeNew);
        }
        this.repaint();
    }

    private void makeImage() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        int w = this.buffer.length;
        int h = this.buffer[0].length;
        if (this.rgbarray == null || this.rgbarray.length < h) {
            this.rgbarray = new int[h];
        }
        int nBin = this.imageSize.height;
        for (int j = 0; j < this.imageSize.width; ++j) {
            for (int i = 0; i < this.imageSize.height; ++i) {
                int color;
                int bin = nBin - i - 1;
                int c_g = (int)(this.buffer[j][bin] * 255.0);
                int c_r = (int)(this.dbuff[j][bin] * 255.0);
                int c_b = (int)((1.0 - this.dbuff[j][bin]) * 255.0);
                if (c_r > 255) {
                    c_r = 255;
                }
                if (c_g > 255) {
                    c_g = 255;
                }
                if (c_b > 255) {
                    c_b = 255;
                }
                if (c_r < 0) {
                    c_r = 0;
                }
                if (c_g < 0) {
                    c_g = 0;
                }
                if (c_b < 0) {
                    c_b = 0;
                }
                this.rgbarray[i] = color = c_b + (c_g << 8) + (c_r << 16) + -16777216;
                this.img.setRGB(j, 0, 1, this.imageSize.height, this.rgbarray, 0, 1);
            }
        }
    }
}

