/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Observable;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.OscillatorNode;
import uk.co.simphoney.audio.SpectrogramDataListener;
import uk.co.simphoney.audio.SpectrumDataBuilder;
import uk.co.simphoney.audio.StaticSpectrogramSynth;
import uk.co.simphoney.audio.gui.CursorObserver;

public class SpectralSliceImage
extends Observable
implements CursorObserver,
SpectrogramDataListener {
    private static final long serialVersionUID = 1L;
    SpectrumDataBuilder spectroData;
    Mapper valMapper;
    Mapper freqMapper;
    long pixPtr = -1L;
    int lastPix = -1;
    StaticSpectrogramSynth synth;
    private Rectangle renderRect;

    SpectralSliceImage(SpectrumDataBuilder provider, Mapper valMapper, Mapper freqMapper, StaticSpectrogramSynth synth) {
        assert (freqMapper != null);
        this.spectroData = provider;
        this.freqMapper = freqMapper;
        this.valMapper = valMapper;
        this.synth = synth;
    }

    void setRect(Rectangle rect) {
        this.renderRect = rect;
    }

    public void drawImage(Graphics2D g, int x, int y) {
        int x3;
        int y2;
        int x2;
        int i;
        int w = this.renderRect.width;
        int h = this.renderRect.height;
        int xx = this.renderRect.x;
        int yy = this.renderRect.y;
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.GREEN);
        float[] freq = this.spectroData.getFreqArray();
        float[] magn = this.spectroData.getMagnitudeAt(this.pixPtr);
        float[] magnX = this.spectroData.getSMagnitudeAt(this.pixPtr);
        if (magn == null) {
            g.drawString(" No data ", 10, 10);
            return;
        }
        assert (magnX != null);
        if (this.pixPtr < 0L) {
            return;
        }
        float[] pFreq = this.spectroData.getPhaseFreqAt(this.pixPtr);
        int n = magn.length;
        double scaleX = w;
        double scaleY = h;
        int x1 = xx + (int)((double)this.freqMapper.eval(freq[0]) * scaleX);
        int y1 = yy + h - (int)((double)this.valMapper.eval(magn[0]) * scaleY);
        for (i = 1; i < n; ++i) {
            x2 = xx + (int)((double)this.freqMapper.eval(freq[i]) * scaleX);
            y2 = yy + h - (int)((double)this.valMapper.eval(magn[i]) * scaleY);
            g.setColor(Color.GREEN);
            g.drawLine(x1, y1, x2, y2);
            if (pFreq != null) {
                x3 = xx + (int)((double)this.freqMapper.eval(pFreq[i]) * scaleX);
                g.setColor(Color.RED);
                g.drawLine(x2, yy + h, x3, y2);
            }
            x1 = x2;
            y1 = y2;
        }
        if (magnX != null) {
            x1 = xx + (int)((double)this.freqMapper.eval(freq[0]) * scaleX);
            y1 = yy + h - (int)((double)this.valMapper.eval(magnX[0]) * scaleY);
            for (i = 1; i < n; ++i) {
                x2 = xx + (int)((double)this.freqMapper.eval(freq[i]) * scaleX);
                y2 = yy + h - (int)((double)this.valMapper.eval(magnX[i]) * scaleY);
                g.setColor(Color.RED);
                g.drawLine(x1, y1, x2, y2);
                if (pFreq != null) {
                    x3 = xx + (int)((double)this.freqMapper.eval(pFreq[i]) * scaleX);
                    g.setColor(Color.RED);
                    g.drawLine(x2, yy + h, x3, y2);
                }
                x1 = x2;
                y1 = y2;
            }
        }
        int pixlast = -100;
        for (int i2 = 0; i2 < n; ++i2) {
            int x22 = xx + (int)((double)this.freqMapper.eval(freq[i2]) * scaleX);
            if (x22 - pixlast <= 50) continue;
            g.setColor(Color.WHITE);
            g.drawString(String.format(" %d ", (int)freq[i2]), x22 - 2, yy + h - 2);
            pixlast = x22;
        }
        if (this.synth != null) {
            for (OscillatorNode osc : this.synth.getOscillatorBank()) {
                if (!osc.active) continue;
                x1 = xx + (int)((double)this.freqMapper.eval((float)osc.getFreq()) * scaleX);
                y1 = yy + h - (int)((double)this.valMapper.eval((float)osc.getAmp()) * scaleY);
                g.setColor(Color.BLUE);
                g.drawLine(x1, h, x1, y1);
            }
        }
    }

    public void notifyCursorChange(int pix) {
        if (this.pixPtr == (long)pix) {
            return;
        }
        this.pixPtr = pix;
        this.setChanged();
        this.notifyObservers();
    }

    public Dimension getPreferredSize() {
        return new Dimension(1000, 120);
    }

    public void notifySizeChange(Dimension d) {
        this.lastPix = -1;
        this.setChanged();
        this.notifyObservers();
    }

    public void notifyMoreDataReady() {
        int nextPix = this.spectroData.getChunkRenderedCount();
        if ((nextPix < this.lastPix || (long)this.lastPix < this.pixPtr) && (long)nextPix >= this.pixPtr) {
            this.setChanged();
            this.notifyObservers();
        }
        this.lastPix = nextPix;
    }
}

