/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.gui.CyclicSpectrogramDataListener;

public class CyclicSpectrogrumImage
extends JPanel
implements CyclicSpectrogramDataListener {
    private static final long serialVersionUID = 1L;
    Dimension size;
    private int[] screenBuffer;
    private boolean dirty = true;
    private double thresh;
    private MemoryImageSource screenConverter;
    private boolean screenRepaint = false;
    int nChunks;
    int nBins;
    int ptr = 0;
    Image offscreen;
    Mapper mapper;
    Object imagSync = new Object();
    boolean recursion = false;

    public CyclicSpectrogrumImage(Mapper mapper, int nChunks) {
        this.nChunks = nChunks;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createGraphics() {
        Object object = this.imagSync;
        synchronized (object) {
            this.size = new Dimension(this.nChunks, this.nBins);
            int width = this.nChunks;
            int height = this.nBins;
            this.screenBuffer = new int[width * height];
            this.screenConverter = new MemoryImageSource(width, height, this.screenBuffer, 0, width);
            this.screenConverter.setAnimated(true);
            this.screenConverter.setFullBufferUpdates(false);
            this.offscreen = Toolkit.getDefaultToolkit().createImage(this.screenConverter);
        }
    }

    public void notifyMoreDataReady(float[] bins) {
        if (this.recursion) {
            System.err.println(" RECURSION ");
        }
        this.nBins = bins.length;
        if (this.nBins == 0) {
            return;
        }
        this.recursion = true;
        if (this.size == null || this.nBins != this.size.height || this.nChunks != this.size.width) {
            this.createGraphics();
        }
        int width = this.size.width;
        for (int i = 0; i < this.nBins; ++i) {
            int c_r;
            int bin = this.nBins - i - 1;
            float val = this.mapper.eval(bins[bin]);
            if (val < 0.0f) {
                val = 0.0f;
            }
            if ((double)val > 1.0) {
                val = 1.0f;
            }
            int c_g = c_r = (int)(255.0f * val);
            int c_b = 255 - c_r;
            int color = c_b + (c_g << 8) + (c_r << 16) + -16777216;
            this.screenBuffer[i * width + this.ptr] = -16777216 + color;
        }
        if (this.ptr % 1 == 0) {
            this.screenConverter.newPixels(this.ptr, 0, 1, this.nBins);
            this.screenRepaint = true;
            this.repaint();
        }
        this.ptr = (this.ptr + 1) % this.size.width;
        this.recursion = false;
    }

    public void paintX(Graphics g) {
        if (this.screenRepaint) {
            g.drawImage(this.offscreen, 0, 0, this);
            this.screenRepaint = false;
        }
    }

    public void paint(Graphics g) {
        if (!this.screenRepaint) {
            return;
        }
        int w = this.size.width - this.ptr;
        int h = this.size.height;
        g.drawImage(this.offscreen, 0, 0, w, h, this.ptr, 0, this.size.width, h, this);
        if (this.ptr != 0) {
            g.drawImage(this.offscreen, w, 0, this.size.width, h, 0, 0, this.ptr, h, this);
        }
        this.screenRepaint = false;
    }

    public int getHeight() {
        if (this.size == null) {
            return 200;
        }
        return this.size.height;
    }
}

