/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.gui.CyclicSpectrogramDataListener;

public class CopyOfCyclicSpectrogrumImage
implements CyclicSpectrogramDataListener {
    private static final long serialVersionUID = 1L;
    BufferedImage img;
    private int[] rgbarray;
    Dimension imageSize;
    Dimension size;
    int scaleX = 1;
    int scaleY = 1;
    private boolean dirty = true;
    private double thresh;
    static final int nLevel = 256;
    static Color[] fcol = new Color[256];
    int nChunks;
    int nBins;
    int ptr;
    Mapper mapper;
    Object imagSync;
    boolean recursion;

    public CopyOfCyclicSpectrogrumImage(Mapper mapper, int nChunks) {
        for (int i = 0; i < 256; ++i) {
            CopyOfCyclicSpectrogrumImage.fcol[i] = new Color(255, 0, 0, i);
        }
        this.ptr = 0;
        this.imagSync = new Object();
        this.recursion = false;
        this.nChunks = nChunks;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createGraphics() {
        Object object = this.imagSync;
        synchronized (object) {
            this.imageSize = new Dimension(this.nChunks, this.nBins);
            this.size = new Dimension(this.nChunks * this.scaleX, this.nBins * this.scaleY);
            System.out.println("Create graphics " + this.size);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
            this.img = graphicsConfiguration.createCompatibleImage(this.imageSize.width, this.imageSize.height, 2);
        }
    }

    public void notifyMoreDataReady(float[] bins) {
        if (this.recursion) {
            System.err.println(" RECURSION ");
        }
        this.nBins = bins.length;
        if (this.nBins == 0) {
            return;
        }
        this.recursion = true;
        if (this.imageSize == null || this.nBins != this.imageSize.height || this.nChunks != this.imageSize.width) {
            this.createGraphics();
        }
        if (this.rgbarray == null || this.rgbarray.length < this.nBins) {
            this.rgbarray = new int[this.nBins];
        }
        for (int i = 0; i < this.nBins; ++i) {
            int color;
            int c_r;
            int bin = this.nBins - i - 1;
            float val = this.mapper.eval(bins[bin]);
            if (val < 0.0f) {
                val = 0.0f;
            }
            if ((double)val > 1.0) {
                val = 1.0f;
            }
            int c_g = c_r = (int)(255.0f * val);
            int c_b = 255 - c_r;
            this.rgbarray[i] = color = c_b + (c_g << 8) + (c_r << 16) + -16777216;
        }
        this.img.setRGB(this.ptr, 0, 1, this.imageSize.height, this.rgbarray, 0, 1);
        this.ptr = (this.ptr + 1) % this.imageSize.width;
        this.recursion = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(Graphics2D g, int dx1, int dy1) {
        if (this.img == null) {
            return;
        }
        Object object = this.imagSync;
        synchronized (object) {
            int w = this.imageSize.width - this.ptr;
            int h = this.imageSize.height;
            g.drawImage(this.img, dx1, dy1, dx1 + w, dy1 + h, this.ptr, 0, this.ptr + w, h, null);
            if (this.ptr != 0) {
                g.drawImage(this.img, dx1 += w, dy1, dx1 + this.ptr, dy1 + h, 0, 0, this.ptr, h, null);
            }
        }
    }

    public int getHeight() {
        if (this.size == null) {
            return 200;
        }
        return this.size.height;
    }
}

