/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.audio.AudioReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JPanel;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.SpectrumDataBuilder;
import uk.co.simphoney.audio.StaticSpectrogramSynth;
import uk.co.simphoney.audio.gui.CursorObserver;
import uk.co.simphoney.audio.gui.SpectrogramImage;
import uk.co.simphoney.audio.gui.WaveImage;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.server.AudioClient;
import uk.org.toot.audio.server.IOAudioProcess;

public class AudioAnalysisTimePanel
extends JPanel
implements Observer {
    Vector<CursorObserver> cursorObservers = new Vector();
    AudioPart part;
    AudioReader input;
    WaveImage wavePanel;
    SpectrogramImage spectroImage;
    boolean isPlaying;
    private Dimension size = new Dimension(400, 100);
    private int chunkCursor;
    private long framePtr = 0L;
    AudioProcess myProcess;
    private boolean staticSynthMode = false;
    StaticSpectrogramSynth synthPlayer;
    private KeyboardFocusManager kbd;
    static int count = 0;
    String tag;
    private KeyEventDispatcher keyDispatcher;

    public AudioAnalysisTimePanel(AudioPart part, Mapper mapper, SpectrumDataBuilder spectroData, KeyboardFocusManager kbd) {
        this.synthPlayer = spectroData.getSynth();
        if (this.synthPlayer != null) {
            this.addCursorObserver(this.synthPlayer);
        }
        this.part = part;
        this.kbd = kbd;
        this.myProcess = new MyAudioProcess();
        this.tag = "XYZ" + count++;
        part.getLane().getProject().addMixerInput(this.myProcess, this.tag);
        try {
            this.spectroImage = new SpectrogramImage(spectroData, mapper);
            this.wavePanel = new WaveImage(part.createAudioReader());
            spectroData.addSizeObserver(this.wavePanel);
            spectroData.addSizeObserver(this.spectroImage);
            this.spectroImage.addObserver(this);
            this.wavePanel.addObserver(this);
            this.addMouseListener(new MyMouseListener());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setFocusable(true);
        this.overrideKeys();
    }

    StaticSpectrogramSynth getSynth() {
        return this.synthPlayer;
    }

    public void dispose() {
        this.wavePanel.deleteObservers();
        this.spectroImage.deleteObservers();
        this.part.getLane().getProject().removeStrip(this.tag);
        this.kbd.removeKeyEventDispatcher(this.keyDispatcher);
        this.keyDispatcher = null;
    }

    public void paintComponent(Graphics gg) {
        super.paintComponent(gg);
        Graphics2D g = (Graphics2D)gg;
        this.spectroImage.drawImage(g, 0, 0);
        this.wavePanel.drawImage(g, 0, this.spectroImage.getHeight());
        g.setColor(Color.RED);
        g.drawLine(this.chunkCursor, 0, this.chunkCursor, this.size.height);
    }

    public void update(Observable o, Object arg) {
        this.size = new Dimension(this.wavePanel.getWidth(), this.spectroImage.getHeight() + this.wavePanel.getHeight());
        this.revalidate();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public Dimension getMaximumSize() {
        return this.size;
    }

    public void addCursorObserver(CursorObserver o) {
        this.cursorObservers.add(o);
    }

    private void notifyCursorObservers() {
        for (CursorObserver o : this.cursorObservers) {
            o.notifyCursorChange(this.chunkCursor);
        }
    }

    public void startStop() {
        System.out.println(" STARTSTOP");
        this.isPlaying = !this.isPlaying;
    }

    public void nudge(int pixs) {
        this.chunkCursor += pixs;
        this.framePtr = this.wavePanel.screenToFrame(this.chunkCursor);
        try {
            this.input.seekFrame(this.framePtr, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.notifyCursorObservers();
        this.repaint();
    }

    public int cursorChunkPos() {
        return this.chunkCursor;
    }

    void overrideKeys() {
        this.keyDispatcher = new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 32: {
                        if (e.getID() == 401) {
                            AudioAnalysisTimePanel.this.startStop();
                        }
                        return true;
                    }
                    case 37: {
                        if (e.getID() == 401) {
                            AudioAnalysisTimePanel.this.nudge(-1);
                        }
                        return true;
                    }
                    case 39: {
                        if (e.getID() == 401) {
                            AudioAnalysisTimePanel.this.nudge(1);
                        }
                        return true;
                    }
                }
                return false;
            }
        };
        this.kbd.addKeyEventDispatcher(this.keyDispatcher);
    }

    public void setSynthMode(boolean b) {
        this.staticSynthMode = b;
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (AudioAnalysisTimePanel.this.chunkCursor == e.getX()) {
                return;
            }
            AudioAnalysisTimePanel.this.chunkCursor = e.getX();
            AudioAnalysisTimePanel.this.framePtr = AudioAnalysisTimePanel.this.wavePanel.screenToFrame(AudioAnalysisTimePanel.this.chunkCursor);
            try {
                AudioAnalysisTimePanel.this.input.seekFrame(AudioAnalysisTimePanel.this.framePtr, false);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            AudioAnalysisTimePanel.this.notifyCursorObservers();
            AudioAnalysisTimePanel.this.repaint();
        }

        public void mouseEntered(MouseEvent arg0) {
            AudioAnalysisTimePanel.this.requestFocusInWindow();
        }
    }

    class MyAudioProcess
    implements AudioProcess {
        private boolean enabled;

        MyAudioProcess() {
            try {
                AudioAnalysisTimePanel.this.input = AudioAnalysisTimePanel.this.part.createAudioReader();
                AudioAnalysisTimePanel.this.input.seekFrame(AudioAnalysisTimePanel.this.framePtr, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public int processAudio(AudioBuffer buffer) {
            buffer.makeSilence();
            if (AudioAnalysisTimePanel.this.staticSynthMode) {
                AudioAnalysisTimePanel.this.synthPlayer.processAudio(buffer);
            } else if (AudioAnalysisTimePanel.this.isPlaying) {
                AudioAnalysisTimePanel.this.input.processAudio(buffer);
                AudioAnalysisTimePanel.this.framePtr += buffer.getSampleCount();
                this.updateCursorFromFramePos();
            } else {
                buffer.makeSilence();
            }
            return 0;
        }

        private void updateCursorFromFramePos() {
            int newCursor = AudioAnalysisTimePanel.this.wavePanel.frameToScreen(AudioAnalysisTimePanel.this.framePtr);
            if (newCursor != AudioAnalysisTimePanel.this.chunkCursor) {
                AudioAnalysisTimePanel.this.chunkCursor = newCursor;
                AudioAnalysisTimePanel.this.notifyCursorObservers();
                AudioAnalysisTimePanel.this.repaint();
            }
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
        }

        public void close() throws Exception {
        }

        public void open() throws Exception {
        }
    }

    class MyClient
    implements AudioClient {
        IOAudioProcess output;
        AudioBuffer buffer = FrinikaAudioSystem.getAudioServer().createAudioBuffer("TiemAnalysis");
        private boolean enabled;

        MyClient() {
            this.output = FrinikaAudioSystem.getDefaultOutput(null);
            try {
                AudioAnalysisTimePanel.this.input = AudioAnalysisTimePanel.this.part.createAudioReader();
                AudioAnalysisTimePanel.this.input.seekFrame(AudioAnalysisTimePanel.this.framePtr, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void work(int size) {
            this.buffer.makeSilence();
            if (AudioAnalysisTimePanel.this.staticSynthMode) {
                AudioAnalysisTimePanel.this.synthPlayer.processAudio(this.buffer);
            } else if (AudioAnalysisTimePanel.this.isPlaying) {
                AudioAnalysisTimePanel.this.input.processAudio(this.buffer);
                AudioAnalysisTimePanel.this.framePtr += this.buffer.getSampleCount();
                this.updateCursorFromFramePos();
            } else {
                this.buffer.makeSilence();
            }
            this.output.processAudio(this.buffer);
        }

        private void updateCursorFromFramePos() {
            int newCursor = AudioAnalysisTimePanel.this.wavePanel.frameToScreen(AudioAnalysisTimePanel.this.framePtr);
            if (newCursor != AudioAnalysisTimePanel.this.chunkCursor) {
                AudioAnalysisTimePanel.this.chunkCursor = newCursor;
                AudioAnalysisTimePanel.this.notifyCursorObservers();
                AudioAnalysisTimePanel.this.repaint();
            }
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
        }
    }
}

