/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.gui;

import com.frinika.sequencer.model.AudioPart;
import com.frinika.sequencer.model.audio.AudioReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import uk.ac.bath.gui.TweakerPanel;
import uk.ac.bath.util.Tweakable;
import uk.ac.bath.util.TweakableDouble;
import uk.co.simphoney.audio.Mapper;
import uk.co.simphoney.audio.SpectrumController;
import uk.co.simphoney.audio.SpectrumDataBuilder;
import uk.co.simphoney.audio.constantq.ConstantQSpectrogramDataBuilder;
import uk.co.simphoney.audio.constantq.ConstantQSpectrumController;
import uk.co.simphoney.audio.gui.AudioAnalysisTimePanel;
import uk.co.simphoney.audio.gui.FFTSpectrogramDataBuilderWrapper;
import uk.co.simphoney.audio.gui.SingleImagePanel;
import uk.co.simphoney.audio.gui.SpectralSliceImage;

public class AudioAnalysisPanel
extends JPanel {
    Vector<Tweakable> tweaks = new Vector();
    TweakableDouble mindB = new TweakableDouble(this.tweaks, -400.0, 100.0, -120.0, 5.0, "minDb");
    TweakableDouble maxdB = new TweakableDouble(this.tweaks, -400.0, 100.0, -10.0, 5.0, "maxDb");
    JToggleButton linearBut;
    private static final long serialVersionUID = 1L;
    AudioAnalysisTimePanel timePanel;
    SingleImagePanel spectroSlicePanel;
    AudioReader reader;
    private ValMapper valMapper;
    private Mapper freqMapper;
    SpectrumDataBuilder spectroData;
    SpectrumController spectroController;
    JPanel spectroPanel;
    private KeyboardFocusManager kbd;

    public AudioAnalysisPanel(final AudioPart part, JFrame frame, KeyboardFocusManager kbd) {
        this.kbd = kbd;
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        try {
            this.reader = part.createAudioReader();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.valMapper = new ValMapper();
        this.maxdB.addObserver(this.valMapper);
        this.mindB.addObserver(this.valMapper);
        JMenu menu = new JMenu("Spectral");
        JMenuItem item = new JMenuItem("FFT");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AudioAnalysisPanel.this.clear();
                AudioAnalysisPanel.this.spectroData = new FFTSpectrogramDataBuilderWrapper(AudioAnalysisPanel.this.reader);
                AudioAnalysisPanel.this.spectroController = ((FFTSpectrogramDataBuilderWrapper)AudioAnalysisPanel.this.spectroData).getController();
                AudioAnalysisPanel.this.setSpectralView(part);
            }
        });
        menu.add(item);
        item = new JMenuItem("constant Q");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AudioAnalysisPanel.this.clear();
                AudioAnalysisPanel.this.spectroData = new ConstantQSpectrogramDataBuilder();
                AudioAnalysisPanel.this.spectroController = new ConstantQSpectrumController((ConstantQSpectrogramDataBuilder)AudioAnalysisPanel.this.spectroData, AudioAnalysisPanel.this.reader);
                AudioAnalysisPanel.this.setSpectralView(part);
            }
        });
        menu.add(item);
        frame.getJMenuBar().add(menu);
    }

    void clear() {
        if (this.spectroData != null) {
            this.spectroData.dispose();
        }
        if (this.timePanel != null) {
            this.timePanel.dispose();
        }
        this.removeAll();
    }

    void setSpectralView(AudioPart part) {
        this.freqMapper = this.spectroController.getFrequencyMapper();
        this.timePanel = new AudioAnalysisTimePanel(part, this.valMapper, this.spectroData, this.kbd);
        SpectralSliceImage spectralSliceImage = new SpectralSliceImage(this.spectroData, this.valMapper, this.freqMapper, this.timePanel.getSynth());
        this.spectroData.addSizeObserver(spectralSliceImage);
        this.timePanel.addCursorObserver(spectralSliceImage);
        this.spectroSlicePanel = new SingleImagePanel(spectralSliceImage);
        this.add((Component)this.spectroSlicePanel, "North");
        JScrollPane scroll = new JScrollPane(this.timePanel);
        this.add((Component)scroll, "Center");
        this.setPreferredSize(new Dimension(1000, 400));
        JPanel buts = new JPanel();
        buts.setLayout(new BoxLayout(buts, 1));
        this.linearBut = new JToggleButton("linear");
        this.linearBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (!AudioAnalysisPanel.this.linearBut.isSelected()) {
                    AudioAnalysisPanel.this.linearBut.setText("Linear");
                } else {
                    AudioAnalysisPanel.this.linearBut.setText("Log10");
                }
                AudioAnalysisPanel.this.valMapper.update(null, null);
            }
        });
        buts.add(this.linearBut);
        final JToggleButton synthBut = new JToggleButton("Synth Mode");
        synthBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AudioAnalysisPanel.this.timePanel.setSynthMode(synthBut.isSelected());
            }
        });
        buts.add(synthBut);
        TweakerPanel tpanel = new TweakerPanel(2, 4);
        for (Tweakable t : this.tweaks) {
            tpanel.addSpinTweaker(t);
        }
        JPanel control = new JPanel();
        control.add(buts);
        control.add(tpanel);
        control.add(this.spectroController.getTweakPanel());
        this.add((Component)control, "South");
        this.valMapper.update(null, null);
        this.spectroController.update();
        this.revalidate();
        this.repaint();
    }

    public void dispose() {
        this.timePanel.dispose();
    }

    final class ValMapper
    implements Observer,
    Mapper {
        double maxdb;
        double mindb;
        double max;
        double min;
        boolean linear;
        private Thread thread;

        ValMapper() {
        }

        public final float eval(float val) {
            if (this.linear) {
                float vv = (float)(((double)val - this.min) / (this.max - this.min));
                return vv;
            }
            double dB = 20.0 * Math.log10((double)val + 1.0E-15);
            float vv = (float)((dB - this.mindb) / (this.maxdb - this.mindb));
            return vv;
        }

        public void update(Observable o, Object arg) {
            this.linear = AudioAnalysisPanel.this.linearBut.isSelected();
            this.maxdb = AudioAnalysisPanel.this.maxdB.doubleValue();
            this.max = Math.pow(10.0, this.maxdb / 20.0);
            this.mindb = AudioAnalysisPanel.this.mindB.doubleValue();
            this.min = Math.pow(10.0, this.mindb / 20.0);
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = new Thread(new Runnable(){

                public void run() {
                    AudioAnalysisPanel.this.spectroSlicePanel.repaint();
                    AudioAnalysisPanel.this.timePanel.spectroImage.update(null, null);
                    ValMapper.this.thread = null;
                }
            });
            this.thread.start();
        }
    }
}

