/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.dft;

import uk.co.simphoney.audio.dft.FFTSpectrogramDataBuilder;
import uk.co.simphoney.audio.dft.FFTSpectrumClient;

public class FFTClient1
implements FFTSpectrumClient {
    private float[][] magnArray;
    private float[][] magnArrayX;
    private double[] logMagn;
    int chunkPtr;
    private int sizeInChunks;
    FFTSpectrogramDataBuilder builder;

    public FFTClient1(FFTSpectrogramDataBuilder builder) {
        this.builder = builder;
    }

    public void setSize(int sizeInChunks, int nBin, float[] freq, double dt) {
        this.magnArray = new float[sizeInChunks][nBin];
        this.magnArrayX = new float[sizeInChunks][nBin];
        this.logMagn = new double[nBin * 2];
        this.sizeInChunks = sizeInChunks;
        this.chunkPtr = 0;
    }

    public float[][] getMagnitude() {
        return this.magnArray;
    }

    public float[][] getSMagnitude() {
        return this.magnArrayX;
    }

    public void process(double[] fftOut, int nBin) {
        int i1;
        int i;
        if (this.chunkPtr >= this.sizeInChunks) {
            try {
                throw new Exception(" ptr tpp big ");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        for (int i2 = 0; i2 < nBin; ++i2) {
            double real = fftOut[2 * i2];
            double imag = fftOut[2 * i2 + 1];
            this.magnArray[this.chunkPtr][i2] = (float)Math.sqrt(real * real + imag * imag);
            this.logMagn[i2] = Math.log(this.magnArray[this.chunkPtr][i2]);
            this.logMagn[i2 + nBin] = 0.0;
        }
        this.builder.getFFT().calcReal(this.logMagn, -1);
        double cutoff = 400.0;
        double Fs = this.builder.getSampleRate();
        for (i = i1 = (int)(Fs / cutoff); i < nBin; ++i) {
            this.logMagn[2 * i + 1] = 0.0;
            this.logMagn[2 * i] = 0.0;
        }
        this.builder.getFFT().calcReal(this.logMagn, 1);
        for (i = 0; i < nBin; ++i) {
            this.magnArrayX[this.chunkPtr][i] = (float)Math.exp(this.logMagn[i] / (double)nBin);
        }
        ++this.chunkPtr;
    }

    public float[] getMagnitudeAt(long chunkPtr) {
        if (this.magnArray == null) {
            return null;
        }
        if (chunkPtr >= (long)this.magnArray.length || chunkPtr < 0L) {
            return null;
        }
        return this.magnArray[(int)chunkPtr];
    }

    public float[] getPhaseAt(long chunkPtr) {
        return null;
    }

    public float[] getPhaseFreqAt(long chunkPtr) {
        return null;
    }

    public int getSizeInChunks() {
        return this.sizeInChunks;
    }

    public int getChunkRenderedCount() {
        return this.chunkPtr;
    }

    public boolean validAt(long chunkPtr2) {
        return chunkPtr2 >= 0L && chunkPtr2 < (long)this.chunkPtr;
    }

    public float[] getSmagnitudeAt(long chunkPtr) {
        if (this.magnArrayX == null) {
            return null;
        }
        if (chunkPtr >= (long)this.magnArrayX.length || chunkPtr < 0L) {
            return null;
        }
        return this.magnArrayX[(int)chunkPtr];
    }
}

