/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio.constantq;

import rasmus.interpreter.sampled.util.FFT;

public class FFTConstantQ {
    double q;
    int k;
    int fftlen;
    double[] freqs;
    double[][] qKernel;
    int[][] qKernel_indexes;
    FFT fft;
    double sampleRate = 44100.0;
    double minFreq = 100.0;
    double maxFreq = 3000.0;
    double binsPerOctave = 12.0;
    double threshold = 0.001;
    double spread = 1.0;
    String kernelsident;

    public FFT getFFT() {
        return this.fft;
    }

    public double[] getFreqs() {
        return this.freqs;
    }

    public int getFFTSize() {
        return this.fftlen;
    }

    public int getNumberOfOutputBands() {
        return this.k;
    }

    public FFTConstantQ(double sampleRate, double minFreq, double maxFreq, double binsPerOctave) {
        this.sampleRate = sampleRate;
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.binsPerOctave = binsPerOctave;
        this.init();
    }

    public FFTConstantQ(double sampleRate, double minFreq, double maxFreq, double binsPerOctave, double threshold, double spread) {
        this.sampleRate = sampleRate;
        this.minFreq = minFreq;
        this.maxFreq = maxFreq;
        this.binsPerOctave = binsPerOctave;
        this.threshold = threshold;
        this.spread = spread;
        this.init();
    }

    private void init() {
        this.q = 1.0 / (Math.pow(2.0, 1.0 / this.binsPerOctave) - 1.0) / this.spread;
        this.k = (int)Math.ceil(this.binsPerOctave * Math.log(this.maxFreq / this.minFreq) / Math.log(2.0));
        double calc_fftlen = Math.ceil(this.q * this.sampleRate / this.minFreq);
        this.fftlen = (int)Math.pow(2.0, Math.ceil(Math.log(calc_fftlen) / Math.log(2.0)));
        this.fft = new FFT(this.fftlen);
        this.qKernel = new double[this.k][];
        this.qKernel_indexes = new int[this.k][];
        this.freqs = new double[this.k];
        double[] temp = new double[this.fftlen * 2];
        double[] ctemp = new double[this.fftlen * 2];
        int[] cindexes = new int[this.fftlen];
        for (int i = 0; i < this.k; ++i) {
            int j;
            double[] sKernel = temp;
            this.freqs[i] = this.minFreq * Math.pow(2.0, (double)i / this.binsPerOctave);
            double len = this.q * this.sampleRate / this.freqs[i];
            for (int j2 = 0; j2 < this.fftlen / 2; ++j2) {
                double aa = ((double)j2 + 0.5) / len;
                if (aa < 0.5) {
                    double a = Math.PI * 2 * aa;
                    double window = 0.5 * (1.0 + Math.cos(a));
                    double x = Math.PI * 2 * this.freqs[i] * ((double)j2 + 0.5) / this.sampleRate;
                    sKernel[this.fftlen + j2 * 2] = (window /= len) * Math.cos(x);
                    sKernel[this.fftlen + j2 * 2 + 1] = window * Math.sin(x);
                    continue;
                }
                sKernel[this.fftlen + j2 * 2] = 0.0;
                sKernel[this.fftlen + j2 * 2 + 1] = 0.0;
            }
            int halfway = this.fftlen / 2;
            for (int j3 = 0; j3 < halfway; ++j3) {
                int i1 = halfway - j3 - 1;
                int i2 = halfway + j3;
                sKernel[i1 * 2] = sKernel[2 * i2];
                sKernel[i1 * 2 + 1] = -sKernel[2 * i2 + 1];
            }
            this.fft.calc(sKernel, -1);
            double[] cKernel = ctemp;
            int k = 0;
            int j4 = 0;
            int j2 = sKernel.length - 2;
            while (j4 < sKernel.length / 2) {
                double absval = Math.sqrt(sKernel[j4] * sKernel[j4] + sKernel[j4 + 1] * sKernel[j4 + 1]);
                if ((absval += Math.sqrt(sKernel[j2] * sKernel[j2] + sKernel[j2 + 1] * sKernel[j2 + 1])) > this.threshold) {
                    cindexes[k] = j4;
                    cKernel[2 * k] = sKernel[j4] + sKernel[j2];
                    cKernel[2 * k + 1] = sKernel[j4 + 1] + sKernel[j2 + 1];
                    ++k;
                }
                j4 += 2;
                j2 -= 2;
            }
            sKernel = new double[k * 2];
            int[] indexes = new int[k];
            for (j = 0; j < k * 2; ++j) {
                sKernel[j] = cKernel[j];
            }
            for (j = 0; j < k; ++j) {
                indexes[j] = cindexes[j];
            }
            j = 0;
            while (j < sKernel.length) {
                int n = j++;
                sKernel[n] = sKernel[n] / (double)this.fftlen;
            }
            for (j = 1; j < sKernel.length; j += 2) {
                sKernel[j] = -sKernel[j];
            }
            this.qKernel_indexes[i] = indexes;
            this.qKernel[i] = sKernel;
        }
    }

    public void calc(double[] buff_in, double[] buff_out) {
        this.fft.calcReal(buff_in, -1);
        for (int i = 0; i < this.qKernel.length; ++i) {
            double[] kernel = this.qKernel[i];
            int[] indexes = this.qKernel_indexes[i];
            double t_r = 0.0;
            double t_i = 0.0;
            int j = 0;
            int l = 0;
            while (j < kernel.length) {
                int jj = indexes[l];
                double b_r = buff_in[jj];
                double b_i = buff_in[jj + 1];
                double k_r = kernel[j];
                double k_i = kernel[j + 1];
                t_r += b_r * k_r - b_i * k_i;
                t_i += b_r * k_i + b_i * k_r;
                j += 2;
                ++l;
            }
            buff_out[i * 2] = t_r;
            buff_out[i * 2 + 1] = t_i;
        }
    }

    public int getFFTlength() {
        return this.fftlen;
    }
}

