/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio;

import com.frinika.global.FrinikaConfig;
import uk.co.simphoney.audio.FloatSinTable;
import uk.co.simphoney.audio.Oscillator;
import uk.org.toot.audio.core.AudioBuffer;

public class OscillatorNode
implements Oscillator {
    double freq1;
    double freq2;
    double amp1;
    double amp2;
    double phaseRef;
    double phase;
    double dphase1;
    double dphase2;
    public boolean active = false;
    boolean steady = false;
    static final double twoPI = Math.PI * 2;

    void start(double freq, double amp, double phaseRef) {
        this.amp1 = 0.0;
        this.amp2 = amp;
        this.freq1 = this.freq2 = freq;
        this.dphase1 = this.dphase2 = Math.PI * 2 * freq / (double)FrinikaConfig.sampleRate;
        this.phase = phaseRef;
        if (this.phase < 0.0) {
            this.phase += Math.PI * 2;
        }
        this.active = true;
    }

    public void close() {
    }

    public double getAmp() {
        return this.amp2;
    }

    public double getFreq() {
        return this.freq2;
    }

    public void open() {
    }

    public int processAudio(AudioBuffer buffer) {
        float[] buff = buffer.getChannel(0);
        int n = buffer.getSampleCount();
        if (this.steady) {
            int i = 0;
            while (i < n) {
                this.phase += this.dphase2;
                if (this.phase >= Math.PI * 2) {
                    this.phase -= Math.PI * 2;
                }
                int n2 = i++;
                buff[n2] = (float)((double)buff[n2] + this.amp2 * FloatSinTable.sinFast(this.phase));
            }
        } else {
            double ddphase = (this.dphase2 - this.dphase1) / (double)n;
            double ddamp = (this.amp2 - this.amp1) / (double)n;
            int i = 0;
            while (i < n) {
                this.phase += this.dphase1;
                this.dphase1 += ddphase;
                if (this.phase >= Math.PI * 2) {
                    this.phase -= Math.PI * 2;
                }
                int n3 = i++;
                buff[n3] = (float)((double)buff[n3] + this.amp1 * FloatSinTable.sinFast(this.phase));
                this.amp1 += ddamp;
            }
        }
        this.steady = true;
        this.active = this.amp2 != 0.0;
        return 0;
    }

    void setNext(double freq, double amp, double phaseRef) {
        this.amp2 = amp;
        this.freq2 = freq;
        this.dphase2 = Math.PI * 2 * this.freq2 / (double)FrinikaConfig.sampleRate;
        this.steady = false;
        this.active = true;
    }

    public String toString() {
        return "f:" + this.freq2 + "  a:" + this.amp2;
    }

    public boolean active() {
        return this.active;
    }

    public void silence() {
        this.amp2 = 0.0;
        this.steady = false;
        this.active = true;
    }
}

