/*
 * Decompiled with CFR 0.152.
 */
package uk.co.simphoney.audio;

import java.text.DecimalFormat;

public class FloatSinTable {
    static final double[] table = FloatSinTable.build(720);
    static double step;
    static double invStep;
    static int size;

    private static final double[] build(int pSize) {
        size = pSize;
        double[] table = new double[size + 1];
        step = (float)(Math.PI * 2 / (double)size);
        invStep = 1.0 / step;
        for (int i = 0; i < size + 1; ++i) {
            table[i] = Math.sin(step * (double)i);
        }
        return table;
    }

    public static final double sinFast(double a) {
        int index = (int)(a / step);
        return table[index];
    }

    public static final double sin(float ang) {
        int indexA = (int)((double)ang / step);
        int indexB = indexA + 1;
        if (indexB >= size) {
            return table[indexA];
        }
        double a = table[indexA];
        return a + (table[indexB] - a) * ((double)ang - (double)indexA * step) * invStep;
    }

    public static void main(String[] args) {
        DecimalFormat df = new DecimalFormat("0.########");
        int max = 10000000;
        float pi = (float)Math.PI;
        for (int i = 0; i < 20; ++i) {
            float angle = (float)(Math.random() * Math.PI * 2.0);
            double sinT = FloatSinTable.sin(angle);
            float sin = (float)Math.sin(angle);
            double delta = (double)sin - sinT;
            System.out.println("sin " + df.format(angle) + " :\t" + sinT + " : " + sin + " DELTA " + delta);
        }
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < max; ++i) {
            double x = FloatSinTable.sin(pi);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("tempo SinTable: " + (t2 - t1));
        long t3 = System.currentTimeMillis();
        for (int i = 0; i < max; ++i) {
            float x = (float)Math.sin(pi);
        }
        long t4 = System.currentTimeMillis();
        System.out.println("tempo Math.sin: " + (t4 - t3));
        long t5 = System.currentTimeMillis();
        for (int i = 0; i < max; ++i) {
            double x = FloatSinTable.sinFast(pi);
        }
        long t6 = System.currentTimeMillis();
        System.out.println("tempo Sintable fast: " + (t6 - t5));
    }

    static {
        size = 0;
    }
}

