/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bath.gui.vamp;

import com.dreamfabric.DKnob;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.bath.gui.vamp.ISender;

public class KnobWidget
extends JPanel {
    private int mBase;
    protected DKnob mKnob = new DKnob();
    protected JLabel mLabelImage;
    private ImageIcon[] mImages;
    private int min;
    private int max;
    private int val;
    private String label;
    private JLabel mLabel;

    public KnobWidget(int width, int height) {
        if (width > 0 && height > 0) {
            this.mKnob = new DKnob(width, height);
        }
        this.mBase = 0;
        this.createWidgets();
        this.layoutWidgets();
    }

    public KnobWidget(String label, int min, int max, int base, ISender sender, ImageIcon[] aImages, int width, int height) {
        this.mBase = base;
        this.mImages = aImages;
        this.min = min;
        this.max = max;
        this.val = base;
        this.label = label;
        if (width > 0 && height > 0) {
            this.mKnob = new DKnob(width, height);
        }
        this.createWidgets();
        this.layoutWidgets();
    }

    protected void createWidgets() {
        this.mKnob.setDragType(3);
        if (this.getLabel() != null) {
            this.mLabel = new JLabel(this.getLabel(), 0);
            this.getJLabel().setHorizontalAlignment(0);
        }
        int oValue = this.getValue();
        this.mKnob.setToolTipText(Integer.toString(oValue + this.mBase));
        this.mKnob.setValue(((float)this.getValue() - this.getValueMin()) / (this.getValueMax() - this.getValueMin()));
        if (this.mImages != null) {
            this.mLabelImage = new JLabel(this.mImages[oValue]);
        }
        this.mKnob.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                KnobWidget.this.eventListener(e);
            }
        });
        this.mKnob.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                KnobWidget.this.eventListener(e);
            }
        });
    }

    private float getValueMax() {
        return this.max;
    }

    private float getValueMin() {
        return this.min;
    }

    private int getValue() {
        return this.val;
    }

    private JLabel getJLabel() {
        return this.mLabel;
    }

    private String getLabel() {
        return this.label;
    }

    protected void eventListener(ChangeEvent e) {
        DKnob t = (DKnob)e.getSource();
        int oValue = (int)((float)Math.round(t.getValue() * (this.getValueMax() - this.getValueMin())) + this.getValueMin());
        String oVStr = Integer.toString(oValue + this.mBase);
        t.setToolTipText(oVStr);
        t.setValueAsString(oVStr);
        if (this.mLabelImage != null) {
            this.mLabelImage.setIcon(this.mImages[oValue]);
        }
    }

    protected void eventListener(MouseWheelEvent e) {
        DKnob t = (DKnob)e.getSource();
        if (t.hasFocus()) {
            t.setValue(t.getValue() - (float)e.getWheelRotation() / (this.getValueMax() - this.getValueMin()));
        }
    }

    public void addEventListener(ChangeListener l) {
        this.mKnob.addChangeListener(l);
    }

    public void addEventListener(MouseWheelListener l) {
        this.mKnob.addMouseWheelListener(l);
    }

    protected void layoutWidgets() {
        if (this.mImages != null) {
            JPanel oPane = new JPanel(new BorderLayout(0, 0));
            oPane.add((Component)this.mKnob, "North");
            if (this.getLabel() != null) {
                oPane.add((Component)this.getJLabel(), "South");
            }
            this.setLayout(new FlowLayout(0, 0, 0));
            this.add(oPane);
            this.add(this.mLabelImage);
        } else {
            this.setLayout(new BorderLayout(0, 0));
            this.add((Component)this.mKnob, "North");
            if (this.getLabel() != null) {
                this.add((Component)this.getJLabel(), "South");
            }
        }
    }

    public void setValue(int v) {
        String oVStr = Integer.toString(v + this.mBase);
        this.mKnob.setToolTipText(oVStr);
        this.mKnob.setValueAsString(oVStr);
        if (this.mLabelImage != null) {
            this.mLabelImage.setIcon(this.mImages[v]);
        }
        this.mKnob.setValue(((float)v - this.getValueMin()) / (this.getValueMax() - this.getValueMin()));
    }

    public void setEnabled(boolean e) {
        this.mKnob.setEnabled(e);
        this.getJLabel().setEnabled(e);
    }
}

