/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bath.gui.vamp;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.bath.gui.vamp.ISender;

public class ComboBoxWidget
extends JPanel {
    JComboBox cb;
    protected Object[] options;
    JLabel jLabel;
    private String label;
    int min;
    private int val;

    public ComboBoxWidget(String label, int min, ISender sender, Object[] options) {
        this.label = label;
        this.options = options;
        this.min = min;
        this.val = min;
        this.jLabel = new JLabel(label, 0);
        this.createWidgets();
        this.layoutWidgets();
    }

    protected void createWidgets() {
        this.cb = new JComboBox<Object>(this.options);
        this.cb.setSelectedIndex(this.getValue() - this.getValueMin());
        this.cb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ComboBoxWidget.this.eventListener(e);
            }
        });
    }

    int getValue() {
        return this.val;
    }

    private int getValueMin() {
        return this.min;
    }

    protected void eventListener(ItemEvent e) {
        if (e.getStateChange() == 1) {
            // empty if block
        }
    }

    public void addEventListener(ActionListener l) {
        this.cb.addActionListener(l);
    }

    public void addEventListener(ItemListener l) {
        this.cb.addItemListener(l);
    }

    protected void layoutWidgets() {
        this.setLayout(new FlowLayout());
        this.cb.setMaximumSize(new Dimension(125, 25));
        this.add(this.jLabel);
        this.add(this.cb);
    }

    public void setValue(int v) {
        this.val = v;
        this.cb.setSelectedIndex(v - this.getValueMin());
    }

    public void setEnabled(boolean e) {
        this.cb.setEnabled(e);
    }
}

