/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths.sampler;

import com.frinika.audio.AudioInput;
import com.frinika.audio.VoiceInterrupt;
import com.frinika.global.FrinikaConfig;
import com.frinika.synth.Oscillator;
import com.frinika.synth.Synth;
import com.frinika.synth.synths.sampler.RecordProgressListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import javax.sound.sampled.TargetDataLine;

public class SamplerOscillator
extends Oscillator {
    AudioInput audioInput;
    boolean monitoring = false;
    boolean recording = false;
    boolean directMonitoring = false;
    boolean stereo = false;
    byte[] inBuffer;
    int recordBufferSize;
    short[] recordBuffer;
    int inputSkip = 0;
    long monitorStartMillis = 0L;
    long inputFramesReadCount = 0L;
    private RecordProgressListener recordProgressListener;

    public SamplerOscillator(Synth synth) {
        super(synth);
        this.nextVoice = synth.getPostOscillator();
    }

    public void startMonitor(TargetDataLine lineIn, boolean stereo) throws Exception {
        this.stopMonitor();
        this.directMonitoring = FrinikaConfig.getDirectMonitoring();
        this.stereo = stereo;
        this.audioInput = new AudioInput(lineIn);
        this.audioInput.start();
        this.audioInput.getLine().start();
        this.monitorStartMillis = System.currentTimeMillis();
        this.inputFramesReadCount = 0L;
        long waitForActiveTimeStart = System.currentTimeMillis();
        while (this.audioInput.getLine().available() == 0 && System.currentTimeMillis() - waitForActiveTimeStart < 1000L) {
            Thread.yield();
        }
        if (this.audioInput.getLine().available() <= 0) {
            throw new Exception("Couldn't start IO on the selected line");
        }
        MemoryUsage memUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        int allocate = (int)((double)(memUsage.getMax() - memUsage.getUsed()) * 0.67) / 4;
        System.out.println("allocate:" + allocate);
        this.recordBuffer = new short[allocate];
        this.recordBufferSize = 0;
        this.synth.getAudioOutput().interruptTransmitter(this, new VoiceInterrupt(){

            public void doInterrupt() {
                SamplerOscillator.this.monitoring = true;
            }
        });
    }

    public void stopMonitor() {
        if (this.monitoring) {
            this.synth.getAudioOutput().interruptTransmitter(this, new VoiceInterrupt(){

                public void doInterrupt() {
                    try {
                        SamplerOscillator.this.monitoring = false;
                        SamplerOscillator.this.audioInput.stop();
                        SamplerOscillator.this.audioInput = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void startRecording() {
        final long recordingStartFrame = this.audioInput.getLine().getLongFramePosition();
        this.synth.getAudioOutput().interruptTransmitter(this, new VoiceInterrupt(){

            public void doInterrupt() {
                SamplerOscillator.this.inputSkip = (int)(recordingStartFrame - SamplerOscillator.this.inputFramesReadCount);
                SamplerOscillator.this.recordBufferSize = 0;
                SamplerOscillator.this.recording = true;
            }
        });
        System.out.println("Start recording");
    }

    public short[][] stopRecording() {
        this.synth.getAudioOutput().interruptTransmitter(this, new VoiceInterrupt(){

            public void doInterrupt() {
                SamplerOscillator.this.recording = false;
            }
        });
        while (this.recording) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int latencyCompensation = this.inputSkip * (this.stereo ? 2 : 1);
        short[] bufLeft = new short[(this.recordBufferSize - latencyCompensation) / (this.stereo ? 2 : 1)];
        short[] bufRight = null;
        if (this.stereo) {
            bufRight = new short[(this.recordBufferSize - latencyCompensation) / 2];
            for (int n = 0; n < this.recordBufferSize - latencyCompensation; n += 2) {
                bufLeft[n / 2] = this.recordBuffer[n - latencyCompensation];
                bufRight[n / 2] = this.recordBuffer[n - latencyCompensation + 1];
            }
        } else {
            System.arraycopy(this.recordBuffer, latencyCompensation, bufLeft, 0, this.recordBufferSize - latencyCompensation);
        }
        this.recordBuffer = null;
        System.out.println("Stop recording");
        if (this.recordProgressListener != null) {
            this.recordProgressListener.finished();
        }
        return new short[][]{bufLeft, bufRight};
    }

    public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
        if (this.monitoring) {
            try {
                if (this.inBuffer == null || this.inBuffer.length != buffer.length * 2) {
                    this.inBuffer = new byte[buffer.length * 2];
                }
                int numOfBytes = (endBufferPos - startBufferPos) * 2;
                if (this.audioInput.getLine().available() >= numOfBytes) {
                    long t1 = System.nanoTime();
                    do {
                        this.audioInput.getLine().read(this.inBuffer, 0, numOfBytes);
                        this.inputFramesReadCount += (long)(numOfBytes / 4);
                        int n = 0;
                        while (n < numOfBytes) {
                            short sample = (short)((0xFF & this.inBuffer[n + 1]) + (0xFF & this.inBuffer[n + 0]) * 256);
                            if (this.recording && this.recordBufferSize < this.recordBuffer.length) {
                                this.recordBuffer[this.recordBufferSize++] = sample;
                            }
                            if (this.directMonitoring) {
                                if (this.stereo) {
                                    n += 2;
                                    continue;
                                }
                                n += 4;
                                continue;
                            }
                            this.synth.getPreOscillator().sampleBuffer[startBufferPos + n / 2] = (float)sample / 32768.0f;
                            if (this.stereo) {
                                n += 2;
                                continue;
                            }
                            this.synth.getPreOscillator().sampleBuffer[startBufferPos + (n / 2 + 1)] = (float)sample / 32768.0f;
                            n += 4;
                        }
                    } while (this.audioInput.getLine().available() > this.inBuffer.length * 2);
                } else {
                    System.out.println("input glip - only " + this.audioInput.getLine().available() + " / " + numOfBytes + " bytes available");
                }
                if (this.recordProgressListener != null) {
                    this.recordProgressListener.updateProgress(this.recordBufferSize);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isMonitoring() {
        return this.monitoring;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public int available() {
        return this.recordBuffer.length - this.recordBufferSize;
    }

    public void setRecordProgressListener(RecordProgressListener recordProgressListener) {
        this.recordProgressListener = recordProgressListener;
    }
}

