/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.synths;

import com.frinika.synth.Oscillator;
import com.frinika.synth.Synth;
import com.frinika.synth.SynthRack;
import com.frinika.synth.soundbank.SynthRackInstrumentIF;
import java.io.Serializable;

public class Organ
extends Synth {
    OrganSettings organSettings = new OrganSettings();

    public Organ(SynthRack synth) {
        super(synth);
    }

    public void noteOn(int noteNumber, int velocity) {
        OrganOscillator osc = new OrganOscillator(this);
        osc.setNoteNumber(noteNumber);
        osc.setVelocity(velocity);
        this.addOscillator(noteNumber, osc);
    }

    public String toString() {
        return "Organ";
    }

    public Serializable getSettings() {
        return this.organSettings;
    }

    public void loadSettings(Serializable settings) {
    }

    class OrganOscillator
    extends Oscillator {
        public OrganOscillator(Synth synth) {
            super(synth);
        }

        public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
            int n = startBufferPos;
            while (n < endBufferPos) {
                float res = (float)(((double)(this.position += this.increment) % (Math.PI * 2) + (double)((float)((double)this.position * 2.0)) % (Math.PI * 2) / 2.0 + (double)((float)((double)this.position * 4.0)) % (Math.PI * 2) / 3.0 + (double)((float)((double)this.position * 6.0)) % (Math.PI * 2) / 4.0 + (double)((float)((double)this.position * 8.0)) % (Math.PI * 2) / 5.0 + (double)((float)((double)this.position * 10.0)) % (Math.PI * 2) / 6.0 + (double)((float)((double)this.position * 12.0)) % (Math.PI * 2) / 7.0 + (double)((float)((double)this.position * 14.0)) % (Math.PI * 2) / 8.0 + (double)((float)((double)this.position * 16.0)) % (Math.PI * 2) / 9.0 + (double)((float)((double)this.position * 18.0)) % (Math.PI * 2) / 10.0 + (double)((float)((double)this.position * 20.0)) % (Math.PI * 2) / 11.0) * (double)0.01f);
                int n2 = n++;
                buffer[n2] = buffer[n2] + res;
                int n3 = n++;
                buffer[n3] = buffer[n3] + res;
                if (this.level > 0.0f) {
                    if (!this.release) continue;
                    this.level = (float)((double)this.level - 0.001);
                    continue;
                }
                Organ.this.getAudioOutput().removeTransmitter(this);
                break;
            }
        }
    }

    public class OrganSettings
    implements SynthRackInstrumentIF,
    Serializable {
        public static final long SerialVersionUID = 1L;

        public String getInstrumentName() {
            return "Organ";
        }

        public void setInstrumentName(String instrumentName) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

