/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.synth.soundbank;

import com.frinika.synth.Synth;
import com.frinika.synth.settings.SynthSettings;
import com.frinika.synth.soundbank.SynthRackSoundbank;
import com.frinika.synth.synths.MySampler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;

public class SynthRackSoundbankReader
extends SoundbankReader {
    public Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        return this.getSoundbank(url.openStream());
    }

    public Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException {
        ObjectInputStream in;
        try {
            in = new ObjectInputStream(stream);
        }
        catch (StreamCorruptedException e) {
            return null;
        }
        try {
            SynthSettings setup = (SynthSettings)in.readObject();
            SynthRackSoundbank soundbank = new SynthRackSoundbank();
            Serializable[] settings = setup.getSynthSettings();
            for (int index = 0; index < settings.length; ++index) {
                if (settings[index] == null) continue;
                String synthName = setup.getSynthClassNames()[index];
                if (synthName == null) break;
                if (synthName.equals("com.petersalomonsen.mystudio.mysynth.synths.SoundFont") || synthName.equals("com.petersalomonsen.mystudio.mysynth.synths.MySampler")) {
                    synthName = MySampler.class.getName();
                }
                try {
                    Synth synth = (Synth)Class.forName(synthName).getConstructors()[0].newInstance(this);
                    synth.loadSettings(setup.getSynthSettings()[index]);
                    Patch patch = new Patch(0, index);
                    soundbank.createAndRegisterInstrument(patch, synth);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return soundbank;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidMidiDataException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fis = new FileInputStream(file);
        Soundbank sbk = null;
        try {
            sbk = this.getSoundbank(fis);
        }
        finally {
            fis.close();
        }
        return sbk;
    }
}

