/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.tools;

import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    public static Vector<MidiPart> splitParts(Vector<MidiPart> selected, long ticksPerBeat) {
        Vector<MidiPart> newParts = new Vector<MidiPart>();
        for (MidiPart part : selected) {
            MidiLane lane = (MidiLane)part.getLane();
            lane.remove(part);
            MidiPart newPart = null;
            long gap = ticksPerBeat * 2L;
            long lastTick = -1L;
            newPart = new MidiPart(lane);
            newParts.add(newPart);
            for (MultiEvent ev : part.getMultiEvents()) {
                long t1 = ev.getStartTick();
                if (lastTick == -1L) {
                    lastTick = ev.getEndTick();
                }
                if (t1 - lastTick > gap) {
                    newPart.setBoundsFromEvents();
                    newPart.commitEventsAdd();
                    newPart = new MidiPart(lane);
                    newParts.add(newPart);
                    lastTick = ev.getEndTick();
                }
                newPart.add(ev);
            }
            if (newPart == null) continue;
            newPart.setBoundsFromEvents();
            newPart.commitEventsAdd();
        }
        return newParts;
    }
}

