/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.tempo;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.midi.message.TempoMessage;
import com.frinika.sequencer.model.tempo.TempoListListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.sound.midi.MidiEvent;

public class TempoList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient TreeMap<Long, MyTempoEvent> treeSet;
    private Vector<MyTempoEvent> list;
    private transient boolean dirty = true;
    private double ticksPerBeat;
    ProjectContainer project;
    transient Vector<TempoListListener> listeners;

    public void addTempoListListener(TempoListListener o) {
        this.listeners.add(o);
    }

    public void removeTempoListListener(TempoListListener o) {
        this.listeners.remove(o);
    }

    public void notifyListeners() {
        for (TempoListListener o : this.listeners) {
            o.notifyTempoListChange();
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.treeSet = new TreeMap();
        for (MyTempoEvent e : this.list) {
            this.treeSet.put(e.tick, e);
        }
        this.dirty = true;
        this.listeners = new Vector();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.reco();
        out.defaultWriteObject();
    }

    public TempoList(double ticksPerBeat, ProjectContainer project) {
        this.project = project;
        this.treeSet = new TreeMap();
        this.list = new Vector();
        this.ticksPerBeat = ticksPerBeat;
        this.listeners = new Vector();
    }

    public synchronized void add(long tick, double bpm) {
        if (this.treeSet.remove(tick) != null) {
            System.out.println(" DUPLICATE TIME REMOVED ");
        }
        this.treeSet.put(tick, new MyTempoEvent(bpm));
        this.dirty = true;
    }

    public synchronized void remove(long tick1, long tick2) {
        this.treeSet.subMap(tick1, tick2).clear();
        this.dirty = true;
    }

    public synchronized void reco() {
        if (!this.dirty) {
            return;
        }
        this.list.clear();
        FrinikaTrackWrapper tempoTrack = null;
        if (this.project != null) {
            tempoTrack = this.project.getTempoTrack();
            tempoTrack.clear();
        }
        long tick = 0L;
        double bpm = 120.0;
        double time = 0.0;
        for (Map.Entry<Long, MyTempoEvent> e : this.treeSet.entrySet()) {
            long deltaTick = e.getKey() - tick;
            e.getValue().time = (time += (double)deltaTick * 60.0 / bpm / this.ticksPerBeat);
            tick = e.getValue().tick = e.getKey();
            bpm = e.getValue().bpm;
            if (tempoTrack != null) {
                try {
                    MidiEvent tempoEvent;
                    TempoMessage tempoMsg = new TempoMessage((float)bpm);
                    e.getValue().tempoEvent = tempoEvent = new MidiEvent(tempoMsg, e.getKey());
                    tempoTrack.add(tempoEvent);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.list.add(e.getValue());
        }
        this.dirty = false;
    }

    public synchronized MyTempoEvent getTempoEventAt(long tick) {
        if (this.dirty) {
            this.reco();
        }
        SortedMap<Long, MyTempoEvent> head = this.treeSet.headMap(tick + 1L);
        MyTempoEvent ev = (MyTempoEvent)head.get(head.lastKey());
        return ev;
    }

    public synchronized float getTempoAt(long tick) {
        SortedMap<Long, MyTempoEvent> head;
        if (this.dirty) {
            this.reco();
        }
        if ((head = this.treeSet.headMap(tick + 1L)).isEmpty()) {
            return 120.0f;
        }
        MyTempoEvent ev = (MyTempoEvent)head.get(head.lastKey());
        return (float)ev.bpm;
    }

    public synchronized double getTickAtTime(double time) {
        if (this.dirty) {
            this.reco();
        }
        MyTempoEvent lastEv = this.list.firstElement();
        if (time < 0.0) {
            return this.ticksPerBeat * time * lastEv.bpm / 60.0;
        }
        for (MyTempoEvent ev : this.list) {
            assert (ev != null);
            if (ev.time > time) break;
            lastEv = ev;
        }
        return (double)lastEv.tick + this.ticksPerBeat * (time - lastEv.time) * lastEv.bpm / 60.0;
    }

    public synchronized double getTimeAtTick(double tick) {
        MyTempoEvent ev;
        Long lastKey;
        long itick;
        SortedMap<Long, MyTempoEvent> head;
        if (this.dirty) {
            this.reco();
        }
        if ((head = this.treeSet.headMap(itick = (long)tick + 1L)).isEmpty()) {
            lastKey = 0L;
            ev = this.treeSet.get(this.treeSet.firstKey());
        } else {
            lastKey = head.lastKey();
            ev = (MyTempoEvent)head.get(lastKey);
        }
        return ev.time + (tick - (double)lastKey.longValue()) * 60.0 / ev.bpm / this.ticksPerBeat;
    }

    public void display() {
        this.reco();
        for (Map.Entry<Long, MyTempoEvent> me : this.treeSet.entrySet()) {
            System.out.println(me.getKey() + " : " + me.getValue().time + " : " + me.getValue().bpm);
        }
    }

    public static void main(String[] args) {
    }

    public int size() {
        return this.treeSet.size();
    }

    public MyTempoEvent elementAt(int row) {
        if (this.dirty) {
            this.reco();
        }
        return this.list.elementAt(row);
    }

    public class MyTempoEvent
    implements Serializable {
        public transient MidiEvent tempoEvent;
        private static final long serialVersionUID = 1L;
        private double bpm;
        private transient double time;
        private long tick;

        private MyTempoEvent() {
        }

        MyTempoEvent(double bpm) {
            this.bpm = bpm;
        }

        void display() {
            System.out.print(this.time + ":" + this.bpm);
        }

        public long getTick() {
            return this.tick;
        }

        public double getBPM() {
            return this.bpm;
        }

        public double getTime() {
            if (TempoList.this.dirty) {
                TempoList.this.reco();
            }
            return this.time;
        }

        public MidiEvent getTempoEvent() {
            return this.tempoEvent;
        }
    }
}

