/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import java.io.IOException;
import java.io.RandomAccessFile;
import javax.sound.sampled.AudioFormat;

public class DAudioReader {
    static String sp = "     ";
    static String indent = sp + "     ";
    private long audioDataStartBytePtr;
    private int audioDataByteLength;
    private int lengthInFrames;
    private RandomAccessFile fis;
    private int bytecount = 0;
    private int riffdata = 0;
    private AudioFormat format;
    int nChannels;
    private long fPtrBytes;

    public DAudioReader(RandomAccessFile fis) throws IOException {
        String sfield = "";
        this.fis = fis;
        long filesize = fis.length();
        this.readChunkHeader();
        while (this.bytecount < this.riffdata) {
            sfield = "";
            for (int i = 1; i <= 4; ++i) {
                sfield = sfield + (char)fis.readByte();
            }
            int chunkSize = 0;
            for (int i = 0; i < 4; ++i) {
                chunkSize += fis.readUnsignedByte() * (int)Math.pow(256.0, i);
            }
            if (sfield.equals("data")) {
                this.audioDataStartBytePtr = fis.getFilePointer();
                this.audioDataByteLength = (int)(filesize - this.audioDataStartBytePtr);
            }
            this.bytecount += 8 + chunkSize;
            if (sfield.equals("fmt ")) {
                this.readFormat(chunkSize);
            } else {
                fis.skipBytes(chunkSize);
            }
            this.lengthInFrames = chunkSize / this.format.getFrameSize();
        }
        if (8 + this.bytecount != (int)filesize) {
            System.out.println(sp + "!!!!!!! Problem with file structure  !!!!!!!!! ");
        }
    }

    private void readChunkHeader() throws IOException {
        int i;
        String sfield = "";
        int chunkSize = 0;
        for (i = 1; i <= 4; ++i) {
            sfield = sfield + (char)this.fis.readByte();
        }
        if (!sfield.equals("RIFF")) {
            System.out.println(" ****  Not a valid RIFF file  ****");
            return;
        }
        for (i = 0; i < 4; ++i) {
            chunkSize += this.fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        sfield = "";
        for (i = 1; i <= 4; ++i) {
            sfield = sfield + (char)this.fis.readByte();
        }
        this.riffdata = chunkSize;
        this.bytecount = 4;
    }

    public int getLengthInFrames() {
        return this.lengthInFrames;
    }

    private void readFormat(int chunkSize) throws IOException {
        if (chunkSize < 16) {
            System.out.println(" ****  Not a valid fmt chunk  ****");
            return;
        }
        int wFormatTag = this.fis.readUnsignedByte();
        this.fis.skipBytes(1);
        this.nChannels = this.fis.readUnsignedByte();
        this.fis.skipBytes(1);
        int nSamplesPerSec = 0;
        for (int i = 0; i < 4; ++i) {
            nSamplesPerSec += this.fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        int nAvgBytesPerSec = 0;
        for (int i = 0; i < 4; ++i) {
            nAvgBytesPerSec += this.fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        int nBlockAlign = 0;
        for (int i = 0; i < 2; ++i) {
            nBlockAlign += this.fis.readUnsignedByte() * (int)Math.pow(256.0, i);
        }
        int nBitsPerSample = 0;
        if (wFormatTag == 1) {
            nBitsPerSample = this.fis.readUnsignedByte();
            this.fis.skipBytes(1);
        } else {
            this.fis.skipBytes(2);
        }
        this.fis.skipBytes(chunkSize - 16);
        this.format = new AudioFormat(nSamplesPerSec, nBitsPerSample, this.nChannels, true, false);
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public void seekFrame(long framePos) throws IOException {
        this.fPtrBytes = framePos * 2L * (long)this.nChannels;
        if (this.fPtrBytes >= 0L) {
            if (this.fPtrBytes < (long)this.audioDataByteLength) {
                this.fis.seek(this.fPtrBytes + this.audioDataStartBytePtr);
            }
        } else {
            this.fis.seek(this.audioDataStartBytePtr);
        }
    }

    public void read(byte[] byteBuffer, int offSet, int n) throws IOException {
        if (this.fPtrBytes < 0L) {
            int nRead = (int)((long)n + this.fPtrBytes);
            if (nRead > 0) {
                int nFill = n - nRead;
                for (int i = 0; i < nFill; ++i) {
                    byteBuffer[i + offSet] = 0;
                }
                this.fis.read(byteBuffer, offSet + nFill, nRead);
            } else {
                for (int i = 0; i < n; ++i) {
                    byteBuffer[i + offSet] = 0;
                }
            }
        } else if (this.fPtrBytes > (long)this.audioDataByteLength) {
            for (int i = 0; i < n; ++i) {
                byteBuffer[i + offSet] = 0;
            }
        } else {
            int nExtra = (int)(this.fPtrBytes + (long)n - (long)this.audioDataByteLength);
            if (nExtra > 0) {
                int nRead = n - nExtra;
                this.fis.read(byteBuffer, offSet, nRead);
                for (int i = nRead; i < n; ++i) {
                    byteBuffer[i + offSet] = 0;
                }
            } else {
                int nread = this.fis.read(byteBuffer, offSet, n);
                if (nread != n) {
                    try {
                        throw new Exception(" Ooops only read " + nread + " out of " + n + "  " + offSet);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.fPtrBytes += (long)n;
    }

    public int getChannels() {
        return this.nChannels;
    }

    public boolean eof() {
        try {
            return this.fPtrBytes - this.audioDataStartBytePtr >= this.fis.length();
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    public long getCurrentFrame() {
        return (this.fPtrBytes - this.audioDataStartBytePtr) / (long)this.nChannels / 2L;
    }
}

