/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import com.frinika.sequencer.model.audio.BufferedRandomAccessFileManager;
import com.frinika.sequencer.model.audio.RandomAccessFileIF;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
implements RandomAccessFileIF {
    private RandomAccessFile in;
    private byte[] cyclicCache;
    private int size;
    private long ptr1;
    private long ptr;
    private long endPtr;
    private boolean closing = false;
    private long ptr2;
    private boolean reading = false;
    private long ptr0;
    private BufferedRandomAccessFileManager manager;
    private boolean xrun = false;

    public BufferedRandomAccessFile(RandomAccessFile in, int buffSize, BufferedRandomAccessFileManager manager) {
        this.in = in;
        this.cyclicCache = new byte[buffSize];
        this.ptr1 = 0L;
        this.ptr2 = 0L;
        try {
            this.endPtr = in.length();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.manager = manager;
        this.size = buffSize;
        assert (this.size > 0);
        try {
            this.ptr = in.getFilePointer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        manager.addClient(this);
    }

    private void waitForRead() {
        while (this.reading) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void fillBuffer() throws IOException {
        this.waitForRead();
        if (this.ptr > this.ptr2 || this.ptr < this.ptr1 || this.xrun) {
            this.xrun = false;
            if (this.ptr < this.endPtr - (long)this.size) {
                this.in.seek(this.ptr);
                int nread = this.in.read(this.cyclicCache, 0, this.size);
                assert (nread == this.size);
                this.ptr1 = this.ptr;
                this.ptr0 = this.ptr1 % (long)this.size;
                this.ptr2 = this.ptr1 + (long)this.size;
                return;
            }
            if (this.ptr < this.endPtr) {
                int nn = (int)(this.endPtr - this.ptr);
                this.in.seek(this.ptr);
                int nread = this.in.read(this.cyclicCache, 0, nn);
                assert (nread == nn);
                this.ptr1 = this.ptr;
                this.ptr0 = this.ptr1 % (long)this.size;
                this.ptr2 = this.ptr1 + (long)nn;
                return;
            }
            try {
                throw new Exception(" CAN NOT FILL BUFFER AFTER END OF FILE ");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        assert (this.ptr >= this.ptr1);
        this.ptr1 = this.ptr;
        int cPtr1 = (int)((this.ptr1 - this.ptr0) % (long)this.size);
        int cPtr2 = (int)((this.ptr2 - this.ptr0) % (long)this.size);
        long navail = (int)(this.endPtr - this.ptr2);
        assert (navail >= 0L);
        if (cPtr2 > cPtr1) {
            int nn;
            int n1 = this.size - cPtr2;
            if (n1 > 0) {
                if ((long)n1 > navail) {
                    int nn2 = this.in.read(this.cyclicCache, cPtr2, (int)navail);
                    assert ((long)nn2 == navail);
                    this.ptr2 += navail;
                    return;
                }
                nn = this.in.read(this.cyclicCache, cPtr2, n1);
                assert (nn == n1);
                this.ptr2 += (long)n1;
                navail -= (long)n1;
            }
            if (cPtr1 <= 0) return;
            if ((long)cPtr1 > navail) {
                nn = this.in.read(this.cyclicCache, 0, (int)navail);
                assert ((long)nn == navail);
                this.ptr2 += navail;
                return;
            }
            nn = this.in.read(this.cyclicCache, 0, cPtr1);
            this.ptr2 += (long)cPtr1;
            assert (nn == cPtr1);
            return;
        }
        int n1 = cPtr1 - cPtr2;
        if (n1 <= 0) return;
        if ((long)n1 > navail) {
            try {
                int nn = this.in.read(this.cyclicCache, cPtr2, (int)navail);
                assert ((long)nn == navail);
                this.ptr2 += navail;
                return;
            }
            catch (Exception e) {
                System.out.println(cPtr1 + "  " + cPtr2 + "  " + navail + "   " + this.size);
                e.printStackTrace();
                this.xrun = true;
                return;
            }
        }
        int nn = this.in.read(this.cyclicCache, cPtr2, n1);
        assert (nn == n1);
        this.ptr2 += (long)n1;
    }

    public final boolean isFull() {
        if (this.ptr2 >= this.endPtr) {
            return true;
        }
        if (this.xrun) {
            return false;
        }
        return this.availableInCache() == this.size;
    }

    public RandomAccessFile getRandomAccesFile() {
        return this.in;
    }

    public final int availableInCache() {
        return (int)(this.ptr2 - this.ptr);
    }

    public int read(byte[] byteBuffer, int offSet, int n, boolean realTime) throws IOException {
        this.reading = true;
        if (this.ptr >= this.endPtr) {
            return 0;
        }
        if (this.availableInCache() < n || this.ptr > this.ptr2 || this.ptr < this.ptr1) {
            if (realTime) {
                try {
                    throw new Exception("audio cache:  xrun ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.xrun = true;
                    this.manager.wakeup();
                }
            } else {
                System.out.println(" REALTIME read ");
                this.reading = false;
                this.fillBuffer();
                this.reading = true;
            }
        }
        int cPtr1 = (int)((this.ptr - this.ptr0) % (long)this.size);
        int cPtr2 = (int)((this.ptr2 - this.ptr0) % (long)this.size);
        if (this.size - cPtr1 > n) {
            System.arraycopy(this.cyclicCache, cPtr1, byteBuffer, offSet, n);
        } else {
            int nn = this.size - cPtr1;
            System.arraycopy(this.cyclicCache, cPtr1, byteBuffer, offSet, nn);
            int nn2 = n - nn;
            System.arraycopy(this.cyclicCache, 0, byteBuffer, offSet + nn, nn2);
        }
        this.ptr += (long)n;
        this.reading = false;
        this.manager.wakeup();
        return n;
    }

    public long getFilePointer() {
        return this.ptr;
    }

    public long length() throws IOException {
        return this.in.length();
    }

    public void seek(long l, boolean realTime) throws IOException {
        if (realTime) {
            this.ptr = l;
            this.fillBuffer();
        } else if (this.ptr != l) {
            this.ptr = l;
            this.manager.wakeup();
        }
    }

    public void close() {
        this.closing = true;
        this.manager.removeClient(this);
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.in;
    }
}

