/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.global.FrinikaConfig;
import com.frinika.gui.DefaultOptionsBinder;
import com.frinika.gui.OptionsBinder;
import com.frinika.gui.OptionsEditor;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.gui.partview.TextPartEditor;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.Selectable;
import com.frinika.sequencer.model.TextLane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TextPart
extends Part {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_WIDTH = 10240;
    public static final String EMPTY_STRING = "...";
    protected String text = "...";
    protected JTextArea renderLabel;
    private static transient HashMap<PartView, TextPartEditor> activeEditors = new HashMap();

    public TextPart(TextLane lane) {
        super(lane);
        this.init();
    }

    private TextPart() {
        this.init();
    }

    private void init() {
        this.renderLabel = new JTextArea();
        this.renderLabel.setLineWrap(true);
        this.renderLabel.setWrapStyleWord(true);
        this.renderLabel.setOpaque(false);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.text == null || !this.text.equals(text)) {
            this.text = text;
            ((TextLane)this.lane).fireChangeEvent();
        }
    }

    public synchronized void startInplaceEdit(PartView partView) {
        TextPartEditor editor = activeEditors.get(partView);
        if (editor != null) {
            editor.editOK();
        }
        Rectangle r = partView.getPartBounds(this);
        r.x += partView.getVirtualScreenRect().x;
        r.y += partView.getVirtualScreenRect().y;
        editor = new TextPartEditor(this, partView, r);
        partView.validate();
        activeEditors.put(partView, editor);
    }

    public synchronized void endInplaceEdit(PartView partView) {
        activeEditors.remove(partView);
    }

    public void attach() {
    }

    public Object clone() throws CloneNotSupportedException {
        TextPart p = new TextPart();
        p.lane = this.lane;
        p.text = this.text;
        p.setStartTick(this.getStartTick());
        p.setEndTick(this.getEndTick());
        return p;
    }

    public void commitEventsAdd() {
    }

    public void commitEventsRemove() {
    }

    public void copyBy(double tick, Lane dst) {
    }

    public void detach() {
    }

    public void drawThumbNail(Graphics2D g, Rectangle rect, PartView partView) {
        this.renderLabel.setSize(rect.width, rect.height);
        this.renderLabel.setText(this.getText());
        this.renderLabel.setFont(FrinikaConfig.TEXT_LANE_FONT);
        g.setColor(Color.WHITE);
        g.fillRect(rect.x + 1, rect.y + 1, rect.width - 1, rect.height - 1);
        g.translate(rect.x, rect.y);
        this.renderLabel.paint(g);
        g.translate(-rect.x, -rect.y);
    }

    public void moveContentsBy(double tick, Lane dstLane) {
        this.setStartTick((double)this.getStartTick() + tick);
        this.setEndTick((double)this.getEndTick() + tick);
    }

    protected void moveItemsBy(long deltaTick) {
    }

    public void onLoad() {
    }

    public Selectable deepCopy(Selectable parent) {
        return null;
    }

    public void deepMove(long tick) {
    }

    public void restoreFromClone(EditHistoryRecordable object) {
    }

    protected void initContextMenu(ProjectFrame frame, JPopupMenu popup) {
        super.initContextMenu(frame, popup);
    }

    protected OptionsEditor createPropertiesPanel(ProjectFrame frame) {
        return new TextPartPropertiesPanel(frame);
    }

    protected class TextPartPropertiesPanel
    extends Part.PropertiesPanel {
        protected OptionsBinder binder;

        protected TextPartPropertiesPanel(ProjectFrame frame) {
            super(frame);
        }

        protected void initComponents() {
            super.initComponents();
            GridBagConstraints gc = new GridBagConstraints();
            gc.insets = new Insets(5, 5, 5, 5);
            gc.gridwidth = 0;
            gc.fill = 2;
            JSeparator sep = new JSeparator();
            this.add((Component)sep, gc);
            JPanel fontpanel = new JPanel();
            fontpanel.setLayout(new BorderLayout(5, 5));
            final JTextField fontTextField = new JTextField();
            JButton fontButton = new JButton("Pick Font...");
            HashMap<Field, Object> bindMap = new HashMap<Field, Object>();
            bindMap.put(FrinikaConfig._TEXT_LANE_FONT.getField(), fontTextField);
            this.binder = new DefaultOptionsBinder(bindMap, null);
            fontTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TextPartPropertiesPanel.this.updateFont(fontTextField.getText());
                }
            });
            fontButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FrinikaConfig.pickFont(TextPartPropertiesPanel.this.frame, fontTextField);
                    TextPartPropertiesPanel.this.updateFont(fontTextField.getText());
                }
            });
            fontpanel.add((Component)new JLabel("Font:"), "West");
            fontpanel.add((Component)fontTextField, "Center");
            fontpanel.add((Component)fontButton, "East");
            this.add((Component)fontpanel, gc);
        }

        private void updateFont(String s) {
            Font font = FrinikaConfig.stringToFont(s);
            if (font != null) {
                FrinikaConfig._TEXT_LANE_FONT.set(font);
                this.frame.repaintPartView();
            }
        }

        public void refresh() {
            super.refresh();
            this.binder.refresh();
        }

        public void update() {
            super.update();
            this.binder.update();
        }
    }
}

