/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.project.MidiDeviceDescriptor;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.RecordableLane;
import com.frinika.sequencer.model.SynthLane;
import java.util.Vector;
import javax.sound.midi.MidiDevice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoloManager {
    ProjectContainer project;
    Vector<RecordableLane> muted = new Vector();
    Vector<RecordableLane> soloed = new Vector();
    Vector<RecordableLane> soloedParent = new Vector();

    public SoloManager(ProjectContainer container) {
        this.project = container;
    }

    private Vector<MidiLane> findMidiLanes(SynthLane sl) {
        Vector<MidiLane> lanes = new Vector<MidiLane>();
        MidiDevice midi = sl.getMidiDescriptor().getMidiDevice();
        for (Lane l : this.project.getLanes()) {
            MidiLane ml;
            MidiDevice md;
            if (!(l instanceof MidiLane) || (md = (ml = (MidiLane)l).getMidiDevice()) != midi) continue;
            lanes.add(ml);
        }
        return lanes;
    }

    private SynthLane findSynthLane(MidiLane lane) {
        MidiDevice midi = lane.getMidiDevice();
        for (Lane l : this.project.getLanes()) {
            SynthLane sl;
            MidiDeviceDescriptor md;
            if (!(l instanceof SynthLane) || (md = (sl = (SynthLane)l).getMidiDescriptor()).getMidiDevice() != midi) continue;
            return sl;
        }
        return null;
    }

    public void toggleSolo(RecordableLane lane) {
        SynthLane sl;
        boolean yes;
        if (!this.soloed.contains(lane)) {
            this.soloed.add(lane);
            yes = true;
        } else {
            this.soloed.remove(lane);
            yes = false;
        }
        if (yes) {
            if (lane instanceof MidiLane) {
                SynthLane sl2 = this.findSynthLane((MidiLane)lane);
                if (sl2 != null) {
                    System.out.println(" Adding midi lane " + sl2.getMidiDescriptor().getMidiDeviceName());
                    if (!this.soloedParent.contains(sl2)) {
                        this.soloedParent.add(sl2);
                    }
                }
            } else if (lane instanceof SynthLane) {
                for (MidiLane ml : this.findMidiLanes((SynthLane)lane)) {
                    if (!ml.isMute()) continue;
                    ml.setMute(false);
                }
            }
        } else if (lane instanceof MidiLane && (sl = this.findSynthLane((MidiLane)lane)) != null) {
            boolean soloedSib = false;
            for (MidiLane ml : this.findMidiLanes(sl)) {
                soloedSib = this.soloed.contains(ml) || soloedSib;
            }
            if (!soloedSib) {
                this.soloedParent.remove(sl);
            }
        }
        this.doit();
    }

    public void toggleMute(RecordableLane lane) {
        if (!this.muted.contains(lane)) {
            this.muted.add(lane);
        } else {
            this.muted.remove(lane);
        }
        this.doit();
    }

    void doit() {
        if (!this.soloed.isEmpty()) {
            System.out.println(" SOLOED LANES");
            for (Lane l : this.project.getLanes()) {
                SynthLane sl;
                if (!(l instanceof RecordableLane)) continue;
                if (!this.soloed.contains(l)) {
                    if (l instanceof SynthLane) {
                        if (this.soloedParent.contains(l)) continue;
                        ((RecordableLane)((Object)l)).setMute(true);
                        continue;
                    }
                    if (l instanceof MidiLane) {
                        sl = this.findSynthLane((MidiLane)l);
                        if (this.soloed.contains(sl)) continue;
                        ((RecordableLane)((Object)l)).setMute(true);
                        continue;
                    }
                    if (!(l instanceof AudioLane) || this.soloed.contains(l)) continue;
                    ((RecordableLane)((Object)l)).setMute(true);
                    continue;
                }
                ((RecordableLane)((Object)l)).setMute(false);
                if (!(l instanceof MidiLane) || (sl = this.findSynthLane((MidiLane)l)) == null) continue;
                sl.setMute(false);
            }
        } else {
            System.out.println(" NO SOLOED LANES");
            for (Lane l : this.project.getLanes()) {
                if (!(l instanceof RecordableLane)) continue;
                ((RecordableLane)((Object)l)).setMute(this.muted.contains(l));
            }
        }
    }

    public boolean isMute(RecordableLane rl) {
        return this.muted.contains(rl);
    }

    public boolean isSolo(RecordableLane rl) {
        return this.soloed.contains(rl);
    }

    public boolean isParentSolo(RecordableLane rl) {
        return this.soloedParent.contains(rl);
    }
}

