/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.gui.virtualkeyboard.VirtualKeyboard;
import com.frinika.sequencer.model.ChannelEvent;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MidiPart;
import java.util.Comparator;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;

public class NoteEvent
extends ChannelEvent {
    public static final Comparator<NoteEvent> noteComparator = new NoteComparator();
    public static final StartComparator startComparator = new StartComparator();
    public static final EndComparator endComparator = new EndComparator();
    private static final long serialVersionUID = 1L;
    transient MidiEvent startEvent;
    transient MidiEvent endEvent;
    int note;
    int velocity;
    long duration;
    boolean valid = false;

    public NoteEvent(FrinikaTrackWrapper track, long startTick, int note, int velocity, int channel, long duration) {
        super(track, startTick);
        this.note = note;
        this.velocity = velocity;
        this.channel = channel;
        this.duration = duration;
    }

    public NoteEvent(MidiPart part, long startTick, int note, int velocity, int channel, long duration) {
        super(part, startTick);
        this.note = note;
        this.velocity = velocity;
        this.channel = channel;
        this.duration = duration;
    }

    NoteEvent(MidiPart part, MidiEvent startEvent) {
        super(part, startEvent.getTick());
        this.startEvent = startEvent;
        ShortMessage shm = (ShortMessage)startEvent.getMessage();
        this.note = shm.getData1();
        this.velocity = shm.getData2();
        this.channel = shm.getChannel();
        this.startTick = startEvent.getTick();
    }

    public void setEndEvent(MidiEvent endEvent) {
        this.endEvent = endEvent;
        this.duration = endEvent.getTick() - this.startTick;
        if (this.duration < 0L) {
            System.out.println(" NEGATIVE LENGTH NOTE FIXED");
            this.duration = 0L;
            endEvent.setTick(this.startEvent.getTick());
        }
        this.valid = true;
    }

    public long getEndTick() {
        return this.startTick + this.duration;
    }

    public int getNote() {
        return this.note;
    }

    public String getNoteName() {
        return VirtualKeyboard.getNoteString(this.note);
    }

    public void setNote(int note) {
        if (this.note == note) {
            return;
        }
        this.note = note;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        if (duration < 0L) {
            System.out.println(" Sorry but I won't make a note negative length ");
            duration = 0L;
            return;
        }
        this.duration = duration;
    }

    void commitRemoveImpl() {
        if (this.zombie) {
            try {
                throw new Exception(" Attempt to remove a zombie note from the track ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.startEvent == null) {
            try {
                throw new Exception(" Attempt to remove a note with null start from the track ");
            }
            catch (Exception e) {
                System.out.println(" You can ignore this exception  . . . . ");
                e.printStackTrace();
            }
        } else {
            this.getTrack().remove(this.startEvent);
        }
        if (this.endEvent == null) {
            try {
                throw new Exception(" Attempt to remove a note with null end from the track ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.getTrack().remove(this.endEvent);
        }
        this.zombie = true;
    }

    public void commitAddImpl() {
        if (this.part.lane == null) {
            return;
        }
        try {
            ShortMessage shm = new ShortMessage();
            shm.setMessage(144, this.channel, this.note, this.velocity);
            this.startEvent = new MidiEvent(shm, this.startTick);
            this.getTrack().add(this.startEvent);
            shm = new ShortMessage();
            shm.setMessage(144, this.channel, this.note, 0);
            this.endEvent = new MidiEvent(shm, this.startTick + this.duration);
            this.getTrack().add(this.endEvent);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        this.zombie = false;
    }

    public void restoreFromClone(EditHistoryRecordable object) {
        NoteEvent note = (NoteEvent)object;
        this.part = note.part;
        this.startTick = note.startTick;
        this.velocity = note.velocity;
        this.channel = note.channel;
        this.duration = note.duration;
        this.note = note.note;
    }

    public void setValue(int val) {
        this.velocity = val;
    }

    public int getValue() {
        return this.velocity;
    }

    public long rightTickForMove() {
        return this.startTick + this.duration;
    }

    public boolean isDrumHit() {
        return this.duration == 0L;
    }

    public void validate() {
        if (this.endEvent == null) {
            System.err.println("Fixing null end event");
            ShortMessage shm = new ShortMessage();
            try {
                shm.setMessage(144, this.channel, this.note, 0);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            this.duration = 0L;
            this.endEvent = new MidiEvent(shm, this.startTick);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NoteComparator
    implements Comparator<NoteEvent> {
        @Override
        public int compare(NoteEvent o1, NoteEvent o2) {
            if (o1.note > o2.note) {
                return 1;
            }
            if (o1.note < o2.note) {
                return -1;
            }
            if (o1.startTick > o2.startTick) {
                return 1;
            }
            if (o1.startTick < o2.startTick) {
                return -1;
            }
            if (o1.startTick + o1.duration > o2.startTick + o2.duration) {
                return 1;
            }
            if (o1.startTick + o1.duration < o2.startTick + o2.duration) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EndComparator
    implements Comparator<NoteEvent> {
        @Override
        public int compare(NoteEvent o1, NoteEvent o2) {
            if (o1.startTick + o1.duration > o2.startTick + o2.duration) {
                return 1;
            }
            if (o1.startTick + o1.duration < o2.startTick + o2.duration) {
                return -1;
            }
            if (o1.startTick > o2.startTick) {
                return 1;
            }
            if (o1.startTick < o2.startTick) {
                return -1;
            }
            if (o1.note > o2.note) {
                return 1;
            }
            if (o1.note < o2.note) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartComparator
    implements Comparator<NoteEvent> {
        @Override
        public int compare(NoteEvent o1, NoteEvent o2) {
            if (o1.startTick > o2.startTick) {
                return 1;
            }
            if (o1.startTick < o2.startTick) {
                return -1;
            }
            if (o1.startTick + o1.duration > o2.startTick + o2.duration) {
                return 1;
            }
            if (o1.startTick + o1.duration < o2.startTick + o2.duration) {
                return -1;
            }
            if (o1.note > o2.note) {
                return 1;
            }
            if (o1.note < o2.note) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

