/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.audio.toot.MidiPeakMonitor;
import com.frinika.midi.MidiInDeviceManager;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.MidiResource;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.midi.MidiListProvider;
import com.frinika.sequencer.midi.MidiMessageListener;
import com.frinika.sequencer.midi.MonitorReceiver;
import com.frinika.sequencer.model.ControllerListProvider;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MidiPlayOptions;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.ProgramChangeEvent;
import com.frinika.sequencer.model.RecordableLane;
import com.frinika.sequencer.model.Selectable;
import com.frinika.sequencer.patchname.MyPatch;
import com.frinika.synth.SynthRack;
import com.frinika.synth.synths.MySampler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import rasmus.midi.provider.RasmusSynthesizer;

public class MidiLane
extends Lane
implements RecordableLane {
    private static final long serialVersionUID = 7079152267067539976L;
    static Icon iconNoteLane = new ImageIcon(RasmusSynthesizer.class.getResource("/icons/midilane.png"));
    static Icon iconDrumLane = new ImageIcon(RasmusSynthesizer.class.getResource("/icons/drumlane.png"));
    transient FrinikaTrackWrapper ftw;
    MidiPart trackHeaderPart = null;
    ProgramChangeEvent programEvent;
    String voiceName;
    Integer midiDeviceIndex;
    int midiChannel;
    public static final int UNKNOWN_TYPE = 0;
    public static final int MELODIC = 1;
    public static final int DRUM = 2;
    public static final int SCORE = 4;
    static int nameCount = 0;
    int laneType;
    MidiPlayOptions playOptions = new MidiPlayOptions();
    transient Collection<MidiMessageListener> midiMessageListeners = new HashSet<MidiMessageListener>();
    transient MidiPeakMonitor peakMonitor = null;
    transient String[] keyNames = null;
    transient boolean isSolo;

    protected MidiLane() {
    }

    private MidiLane(MidiLane cloneMe) {
        super("Copy of " + cloneMe.getName(), cloneMe.project);
        this.trackHeaderPart = (MidiPart)cloneMe.trackHeaderPart.deepCopy(null);
        this.trackHeaderPart.lane = this;
        this.midiDeviceIndex = cloneMe.midiDeviceIndex;
        this.midiChannel = cloneMe.midiChannel;
        this.keyNames = cloneMe.keyNames;
        for (Part part : cloneMe.getParts()) {
            part.deepCopy(this);
        }
        this.ftw = cloneMe.ftw.getSequence().createFrinikaTrack();
        this.ftw.setMidiChannel(this.midiChannel);
        this.setUpKeys();
    }

    public MidiLane(FrinikaTrackWrapper ftw, ProjectContainer project) {
        super("Midi " + nameCount++, project);
        this.ftw = ftw;
        this.trackHeaderPart = new MidiPart();
        this.trackHeaderPart.lane = this;
        this.programEvent = new ProgramChangeEvent(this.trackHeaderPart, 0L, 0, 0, 0);
        this.programEvent.commitAdd();
    }

    public MidiPart getHeadPart() {
        return this.trackHeaderPart;
    }

    public FrinikaTrackWrapper getTrack() {
        return this.ftw;
    }

    public MidiDevice getMidiDevice() {
        return this.ftw.getMidiDevice();
    }

    public Receiver getReceiver() {
        MidiDevice dev = this.ftw.getMidiDevice();
        if (dev == null) {
            return null;
        }
        try {
            Receiver r = this.ftw.getMidiDevice().getReceiver();
            if (r != null) {
                return new MonitorReceiver(this.midiMessageListeners, r);
            }
            return null;
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getMidiChannel() {
        return this.ftw.getMidiChannel();
    }

    public int getStoredMidiChannel() {
        return this.midiChannel;
    }

    public void restoreFromClone(EditHistoryRecordable object) {
    }

    public ControllerListProvider getControllerList() {
        MidiDevice dev = this.getMidiDevice();
        if (dev == null) {
            return MidiResource.getDefaultControllerList();
        }
        if (dev instanceof MidiListProvider) {
            return ((MidiListProvider)((Object)dev)).getControllerList();
        }
        return MidiResource.getDefaultControllerList();
    }

    public void attachFTW() {
        this.ftw.attachToSequence();
    }

    public void detachFTW() {
        this.ftw.detachFromSequence();
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public void setVoiceName(String name) {
        this.voiceName = name;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.midiChannel = this.ftw.getMidiChannel();
        if (this.ftw.getMidiDevice() != null) {
            this.midiDeviceIndex = this.project.getMidiDeviceIndex(this.ftw.getMidiDevice());
        }
        out.defaultWriteObject();
    }

    public void onLoad() {
        super.onLoad();
        this.ftw.setMidiChannel(this.midiChannel);
        if (this.midiDeviceIndex != null) {
            try {
                this.ftw.setMidiDevice(this.project.getSequencer().listMidiOutDevices().get(this.midiDeviceIndex));
            }
            catch (Exception e) {
                System.out.println("WARNING: Was unable to connect to external midi device");
            }
        }
        this.setUpKeys();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (this.getProject().getSequence() == null) {
            this.getProject().createSequence();
        }
        this.ftw = this.getProject().getSequence().createFrinikaTrack();
        in.defaultReadObject();
        if (this.programEvent == null) {
            this.trackHeaderPart = new MidiPart();
            this.trackHeaderPart.lane = this;
            this.programEvent = new ProgramChangeEvent(this.trackHeaderPart, 0L, 0, 0, 0);
        }
        this.midiMessageListeners = new HashSet<MidiMessageListener>();
        this.programEvent.commitAdd();
    }

    public void setProgram(int prog, int msb, int lsb) {
        this.programEvent.commitRemove();
        this.programEvent.setProgram(prog, msb, lsb);
        this.programEvent.commitAdd();
        this.setUpKeys();
    }

    public void setProgram(MyPatch patch) {
        this.programEvent.commitRemove();
        this.programEvent.setProgram(patch.prog, patch.msb, patch.lsb);
        this.programEvent.commitAdd();
        this.setUpKeys();
    }

    public MyPatch getProgram() {
        MyPatch patch = null;
        FrinikaTrackWrapper track = this.ftw;
        int count = track.size();
        for (int i = 0; i < count; ++i) {
            MidiEvent event = track.get(i);
            if (event.getTick() != 0L) {
                return patch;
            }
            MidiMessage msg = event.getMessage();
            if (!(msg instanceof ShortMessage)) continue;
            ShortMessage sms = (ShortMessage)msg;
            if (sms.getCommand() == 192) {
                if (patch == null) {
                    patch = new MyPatch(0, 0, 0);
                }
                patch.prog = sms.getData1();
            }
            if (sms.getCommand() != 176) continue;
            if (sms.getData1() == 0) {
                if (patch == null) {
                    patch = new MyPatch(0, 0, 0);
                }
                patch.msb = sms.getData2();
            }
            if (sms.getData1() != 32) continue;
            if (patch == null) {
                patch = new MyPatch(0, 0, 0);
            }
            patch.lsb = sms.getData2();
        }
        return patch;
    }

    public Selectable deepCopy(Selectable parent) {
        MidiLane clone = new MidiLane(this);
        return clone;
    }

    public void deepMove(long tick) {
    }

    public void addToModel() {
        super.addToModel();
        this.onLoad();
    }

    public boolean isRecording() {
        return this.project.getSequencer().isRecording(this);
    }

    public boolean isMute() {
        return this.playOptions.muted;
    }

    public boolean isSolo() {
        return this.isSolo;
    }

    public void setRecording(boolean b) {
        MidiInDeviceManager.open();
        if (b) {
            this.project.getSequencer().recordEnable(this);
        } else {
            this.project.getSequencer().recordDisable(this);
        }
    }

    public void setMute(boolean b) {
        this.playOptions.muted = b;
    }

    public void setSolo(boolean b) {
        this.isSolo = b;
    }

    public double getMonitorValue() {
        if (this.peakMonitor == null) {
            this.peakMonitor = new MidiPeakMonitor();
            this.addMidiMessageListener(this.peakMonitor);
        }
        return this.peakMonitor.getPeak();
    }

    public MidiPlayOptions getPlayOptions() {
        if (this.playOptions == null) {
            this.playOptions = new MidiPlayOptions();
        }
        return this.playOptions;
    }

    public void addMidiMessageListener(MidiMessageListener l) {
        this.midiMessageListeners.add(l);
    }

    public void removeMidiMessageListener(MidiMessageListener l) {
        this.midiMessageListeners.remove(l);
    }

    public void setMidiChannel(int channel) {
        this.midiChannel = channel;
        this.ftw.setMidiChannel(this.midiChannel);
        this.setUpKeys();
    }

    public boolean isDrumLane() {
        return this.laneType == 2 || this.laneType == 0 && this.midiChannel == 9;
    }

    public void setMidiDevice(MidiDevice dev) {
        this.ftw.setMidiDevice(dev);
        this.setUpKeys();
    }

    public void setType(int type) {
        this.laneType = type;
        this.setUpKeys();
    }

    public int getType() {
        return this.laneType;
    }

    /*
     * Unable to fully structure code
     */
    protected void setUpKeys() {
        this.getPlayOptions();
        this.keyNames = null;
        if (!this.isDrumLane()) {
            this.playOptions.drumMapped = false;
        } else {
            if (this.playOptions.noteMap != null) {
                this.playOptions.drumMapped = true;
            }
            inst = null;
            dev = this.getMidiDevice();
            if (dev instanceof SynthRack) {
                syn = ((SynthRack)dev).getSynth(this.midiChannel);
                if (syn instanceof MySampler) {
                    this.keyNames = new String[128];
                    mys = (MySampler)syn;
                    ssss = mys.sampledSounds;
                    for (i = 0; i < 128; ++i) {
                        if (ssss[i][0] == null) continue;
                        this.keyNames[i] = ssss[i][0].toString();
                    }
                }
            } else if (dev instanceof SynthWrapper && (dev = ((SynthWrapper)dev).getRealDevice()) instanceof Synthesizer) {
                synth = (Synthesizer)dev;
                patch = this.getProgram();
                getChannels = null;
                arr$ = insts = synth.getLoadedInstruments();
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    li = ins = arr$[i$];
                    channels = null;
                    try {
                        if (getChannels != null && getChannels.getDeclaringClass() != li.getClass()) {
                            getChannels = null;
                        }
                        if (getChannels == null) {
                            getChannels = li.getClass().getMethod("getChannels", new Class[0]);
                        }
                        if (getChannels != null) {
                            channels = (boolean[])getChannels.invoke((Object)li, (Object[])null);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (channels == null || ins.getPatch().getProgram() != patch.prog || !channels[this.midiChannel]) continue;
                    inst = ins;
                    break;
                }
                if (inst == null) {
                    arr$ = insts = synth.getAvailableInstruments();
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        li = ins = arr$[i$];
                        channels = null;
                        try {
                            if (getChannels != null && getChannels.getDeclaringClass() != li.getClass()) {
                                getChannels = null;
                            }
                            if (getChannels == null) {
                                getChannels = li.getClass().getMethod("getChannels", new Class[0]);
                            }
                            if (getChannels != null) {
                                channels = (boolean[])getChannels.invoke((Object)li, (Object[])null);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (channels == null || ins.getPatch().getProgram() != patch.prog || !channels[this.midiChannel]) continue;
                        inst = ins;
                        break;
                    }
                }
                if (inst != null) {
                    try {
                        getKeys = inst.getClass().getMethod("getKeys", new Class[0]);
                        if (getKeys == null) ** GOTO lbl72
                        this.keyNames = (String[])getKeys.invoke(inst, (Object[])null);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
lbl72:
        // 9 sources

        this.notifyFocusListeners();
    }

    private void notifyFocusListeners() {
        Part f = (Part)this.project.getPartSelection().getFocus();
        if (f == null) {
            return;
        }
        if (f.getLane() == this) {
            this.project.getPartSelection().setDirty();
            this.project.getPartSelection().notifyListeners();
        }
    }

    public String[] getKeyNames() {
        return this.keyNames;
    }

    public void setDrumMapping(int k, int index) {
        this.playOptions.drumMapped = true;
        if (this.playOptions.noteMap == null) {
            this.playOptions.noteMap = new int[128];
            for (int i = 0; i < 128; ++i) {
                this.playOptions.noteMap[i] = i;
            }
        }
        this.playOptions.noteMap[k] = index;
        System.out.println(k + "--->" + index);
        this.notifyFocusListeners();
    }

    public int mapNote(int num) {
        if (this.playOptions.drumMapped) {
            return this.playOptions.noteMap[num];
        }
        return num;
    }

    public Part createPart() {
        return new MidiPart(this);
    }

    public Icon getIcon() {
        if (this.isDrumLane()) {
            return iconDrumLane;
        }
        return iconNoteLane;
    }

    public Integer getMidiDeviceIndex() {
        return this.midiDeviceIndex;
    }
}

