/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.EditHistoryRecorder;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.Selectable;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import uk.org.toot.audio.core.AudioBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lane
implements Selectable,
EditHistoryRecordable,
EditHistoryRecorder<Part>,
Serializable {
    private static final long serialVersionUID = -2220043314267459844L;
    transient boolean selected = false;
    transient AudioBuffer.MetaInfo channelLabel = null;
    Color color;
    protected List<Part> parts;
    protected List<Lane> children;
    private transient int displayY;
    private transient int displayH;
    protected int height;
    boolean open = true;
    boolean hidden = false;
    transient int visibleID;
    transient int uniqueID;
    private String name;
    ProjectContainer project;
    private transient int indexInList = -1;
    int soloMuteFlags = 0;

    protected Lane() {
    }

    protected Lane(String name, ProjectContainer project) {
        this.height = 1;
        this.project = project;
        this.parts = new Vector<Part>();
        this.children = new Vector<Lane>();
        this.setName(name);
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public void removeAll() {
        Vector<Part> partsCopy = new Vector<Part>(this.parts);
        for (Part part : partsCopy) {
            this.remove(part);
        }
    }

    @Override
    public void remove(Part part) {
        part.commitEventsRemove();
        this.parts.remove(part);
        if (part.isSelected()) {
            part.lane.project.getPartSelection().removeSelected(part);
        }
        this.project.getEditHistoryContainer().push(this, 1, part);
    }

    @Override
    public void add(Part part) {
        this.parts.add(part);
        part.lane = this;
        part.commitEventsAdd();
        this.project.getEditHistoryContainer().push(this, 0, part);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getHeight() {
        return this.height;
    }

    public ProjectContainer getProject() {
        return this.project;
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void addChildLane(Lane lane) {
        if (lane.indexInList == -1) {
            this.children.add(lane);
        } else {
            this.children.add(lane.indexInList, lane);
        }
        if (lane instanceof MidiLane) {
            ((MidiLane)lane).attachFTW();
        }
    }

    public void addChildLane(int indexInList, Lane lane) {
        this.children.add(indexInList, lane);
        if (lane instanceof MidiLane) {
            ((MidiLane)lane).attachFTW();
        }
    }

    public void removeChildLane(Lane lane) {
        int pos;
        lane.indexInList = pos = this.children.indexOf(lane);
        this.children.remove(lane);
        if (lane instanceof MidiLane) {
            ((MidiLane)lane).detachFTW();
        }
    }

    public List<Lane> getFamilyLanes() {
        Vector<Lane> lanes = new Vector<Lane>();
        lanes.add(this);
        if (this.children != null) {
            for (Lane child : this.children) {
                lanes.addAll(child.getFamilyLanes());
            }
        }
        return lanes;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isOpen() {
        return this.open;
    }

    public List<Lane> getChildren() {
        return this.children;
    }

    public int getDisplayY() {
        return this.displayY;
    }

    public int getDisplayH() {
        return this.displayH;
    }

    void setDisplayPos(int y, int h, int id) {
        this.displayY = y;
        this.displayH = h;
        this.visibleID = id;
    }

    public int getDisplayID() {
        return this.visibleID;
    }

    public void setHidden(boolean b) {
        this.hidden = b;
    }

    public void setOpen(boolean b) {
        this.open = b;
    }

    public void setName(String name) {
        this.name = name;
        this.channelLabel = new AudioBuffer.MetaInfo(name);
    }

    public void onLoad() {
        if (this.getParts() == null) {
            return;
        }
        for (Part part : this.getParts()) {
            try {
                part.onLoad();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Lane lane : this.getChildren()) {
            lane.onLoad();
        }
    }

    @Override
    public void removeFromModel() {
        this.project.remove(this);
        this.detachComponents();
        System.out.println(" REMOVE LANE ");
    }

    private void detachComponents() {
        for (Part part : this.getParts()) {
            part.detach();
        }
        for (Lane lane : this.getChildren()) {
            lane.detachComponents();
        }
    }

    @Override
    public void addToModel() {
        this.project.add(this);
        this.attachComponents();
        System.out.println(" Add LANE ");
    }

    private void attachComponents() {
        for (Part part : this.getParts()) {
            part.attach();
        }
        for (Lane lane : this.getChildren()) {
            lane.attachComponents();
        }
    }

    @Override
    public long leftTickForMove() {
        return 0L;
    }

    @Override
    public long rightTickForMove() {
        return 0L;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.height = 1;
        this.setName(this.name);
    }

    public void setHeight(int i) {
        this.height = i;
    }

    public void displayStructure(String prefix, PrintStream out) {
        out.println(prefix + " " + this.toString());
        prefix = prefix + "*";
        if (this.children != null) {
            for (Lane lane : this.children) {
                lane.displayStructure(prefix, out);
            }
        }
        if (this.parts != null) {
            for (Part part : this.parts) {
                part.displayStructure(prefix, out);
            }
        }
    }

    public abstract Part createPart();

    public abstract Icon getIcon();
}

