/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;

public class GluePartEditAction
implements EditHistoryAction {
    ProjectContainer project;
    MidiPart origPart1;
    MidiPart origPart2 = null;
    MidiPart newPart = null;

    public GluePartEditAction(MidiPart part) {
        this.origPart1 = part;
        this.project = part.getLane().getProject();
    }

    public void undo() {
        if (this.newPart == null) {
            return;
        }
        this.newPart.commitEventsRemove();
        this.newPart.lane.parts.remove(this.newPart);
        this.origPart1.lane.parts.add(this.origPart1);
        this.origPart1.commitEventsAdd();
        this.origPart2.lane.parts.add(this.origPart2);
        this.origPart2.commitEventsAdd();
        this.project.getPartSelection().removeSelected(this.newPart);
    }

    public void redo() {
        if (this.newPart == null) {
            MultiEvent eNew;
            this.origPart2 = this.findNearest(this.origPart1);
            if (this.origPart2 == null) {
                System.out.println(" Need at least 2 parts in the lane to use glue");
                return;
            }
            this.newPart = new MidiPart((MidiLane)this.origPart1.getLane());
            this.newPart.setStartTick(Math.min(this.origPart1.getStartTick(), this.origPart2.getStartTick()));
            this.newPart.setEndTick(Math.max(this.origPart1.getEndTick(), this.origPart2.getEndTick()));
            for (MultiEvent ev : this.origPart1.getMultiEvents()) {
                eNew = (MultiEvent)ev.deepCopy(this.newPart);
                this.newPart.getMultiEvents().add(eNew);
            }
            for (MultiEvent ev : this.origPart2.getMultiEvents()) {
                eNew = (MultiEvent)ev.deepCopy(this.newPart);
                this.newPart.getMultiEvents().add(eNew);
            }
        }
        this.origPart1.commitEventsRemove();
        this.origPart1.lane.parts.remove(this.origPart1);
        this.origPart2.commitEventsRemove();
        this.origPart2.lane.parts.remove(this.origPart2);
        this.newPart.commitEventsAdd();
        this.project.getPartSelection().removeSelected(this.origPart1);
        this.project.getPartSelection().removeSelected(this.origPart2);
    }

    MidiPart findNearest(Part ref) {
        long dist = Long.MAX_VALUE;
        long start = ref.getStartTick();
        Part part2 = null;
        for (Part part : ref.getLane().getParts()) {
            long dist2;
            if (part == ref) continue;
            long end2 = part.getEndTick();
            long start2 = part.getStartTick();
            if (start2 >= start || Math.abs(dist2 = end2 - start) >= dist) continue;
            part2 = part;
            dist = Math.abs(dist2);
        }
        return (MidiPart)part2;
    }
}

