/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.audio.toot.FrinikaAudioServer;
import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.FrinikaConfig;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.AudioAnalysisAction;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.Selectable;
import com.frinika.sequencer.model.audio.AudioClipReader;
import com.frinika.sequencer.model.audio.AudioReader;
import com.frinika.sequencer.model.audio.AudioStreamVoice;
import com.frinika.sequencer.model.audio.BufferedRandomAccessFile;
import com.frinika.sequencer.model.audio.EnvelopedAudioReader;
import com.frinika.sequencer.model.audio.VanillaRandomAccessFile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import javax.sound.sampled.AudioFileFormat;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.server.AudioServer;

public class AudioPart
extends Part {
    private static final long serialVersionUID = 1L;
    private String audioFileName;
    private String audioDir;
    double realStartTimeInMicros = 0.0;
    transient AudioStreamVoice outputProcess = null;
    transient int nChannel;
    private transient Image thumbNailImage = null;
    private transient AudioReader thumbNailIn = null;
    private transient int buffSize;
    private transient ThumbNailRunnable thumbNailRunnable;
    static AudioFileFormat.Type targetType = AudioFileFormat.Type.WAVE;
    transient EnvelopedAudioReader audioPlayerIn;
    Envelope envelope;
    transient Rectangle lastRect = null;
    static double minT = 1.0;
    static int danc = 1;
    static Rectangle anc = new Rectangle(0, 0, 3 * danc, 3 * danc);

    public AudioPart(AudioLane lane) {
        super(lane);
        this.init();
    }

    public AudioPart() {
        this.init();
    }

    private void init() {
        this.realStartTimeInMicros = 0.0;
        this.outputProcess = null;
        this.nChannel = 1;
        this.buffSize = 100000;
    }

    public AudioPart(Lane lane, File clipFile, double startTimeInMicros) {
        super(lane);
        this.init();
        this.audioDir = clipFile.getParent();
        this.audioFileName = clipFile.getName();
        this.realStartTimeInMicros = startTimeInMicros;
        if (!clipFile.exists()) {
            try {
                System.err.println(" Missing audio file " + clipFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            clipFile = null;
        }
        this.createFileHandles(clipFile);
    }

    private void createFileHandles(File clipFile) {
        boolean newEnvelope;
        AudioServer audioServer = this.lane.getProject().getAudioServer();
        boolean bl = newEnvelope = this.envelope == null;
        if (newEnvelope) {
            this.envelope = new Envelope();
        }
        double lengthInMicros = 0.0;
        if (clipFile != null) {
            try {
                RandomAccessFile raf = new RandomAccessFile(clipFile, "r");
                BufferedRandomAccessFile braf = new BufferedRandomAccessFile(raf, this.buffSize, this.lane.getProject().getAudioFileManager());
                this.audioPlayerIn = new EnvelopedAudioReader(braf);
                RandomAccessFile rafG = new RandomAccessFile(clipFile, "r");
                this.thumbNailIn = new AudioReader(new VanillaRandomAccessFile(rafG));
                if (this.audioPlayerIn.getFormat().getSampleRate() != (float)FrinikaConfig.sampleRate) {
                    try {
                        throw new Exception(" unsupport format " + this.audioPlayerIn.getFormat());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                lengthInMicros = (double)((float)this.audioPlayerIn.getLengthInFrames() / this.audioPlayerIn.getFormat().getSampleRate()) * 1000000.0;
                System.out.println("audioPart:" + clipFile + " " + lengthInMicros / 1000000.0 + " secs");
                this.outputProcess = new AudioStreamVoice(audioServer, this.lane.getProject().getSequencer(), this.audioPlayerIn, (long)this.realStartTimeInMicros);
                this.nChannel = this.audioPlayerIn.getFormat().getChannels();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.envelope.setMaxTime(lengthInMicros);
        if (newEnvelope) {
            this.envelope.setTOn(0.0);
            this.envelope.setTOff(lengthInMicros);
        }
        this.refreshEnvelope();
    }

    public void refreshEnvelope() {
        if (this.envelope == null) {
            return;
        }
        this.envelope.validate();
        if (this.audioPlayerIn == null) {
            return;
        }
        this.audioPlayerIn.setEvelope(this.envelope);
        this.thumbNailIn.setBoundsInMicros(this.envelope.tOn, this.envelope.tOff);
    }

    public File getAudioFile() {
        return new File(this.audioDir, this.audioFileName);
    }

    protected void moveItemsBy(long deltaTick) {
        assert (false);
    }

    public void addToModel() {
        super.addToModel();
        System.out.println(" Adding " + this + " to model ");
        try {
            this.onLoad();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.removeFromModel();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AudioPart clone = new AudioPart();
        clone.audioDir = this.audioDir;
        clone.audioFileName = this.audioFileName;
        clone.realStartTimeInMicros = this.realStartTimeInMicros;
        clone.envelope = (Envelope)this.envelope.clone();
        File clipFile = new File(this.audioDir, this.audioFileName);
        return clone;
    }

    public void restoreFromClone(EditHistoryRecordable object) {
        AudioPart clone = (AudioPart)object;
        this.audioDir = clone.audioDir;
        this.audioFileName = clone.audioFileName;
        this.realStartTimeInMicros = clone.realStartTimeInMicros;
        this.envelope = clone.envelope;
        File clipFile = new File(this.audioDir, this.audioFileName);
    }

    public void copyBy(double tick, Lane dst) {
        try {
            AudioPart clone = new AudioPart((AudioLane)dst, new File(this.audioDir, this.audioFileName), (long)this.realStartTimeInMicros);
            clone.envelope = (Envelope)this.envelope.clone();
            clone.onLoad();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Selectable deepCopy(Selectable parent) {
        AudioPart clone = new AudioPart((AudioLane)parent);
        clone.audioDir = this.audioDir;
        clone.audioFileName = this.audioFileName;
        clone.realStartTimeInMicros = this.realStartTimeInMicros;
        clone.envelope = (Envelope)this.envelope.clone();
        if (parent == null) {
            clone.lane = this.lane;
        }
        clone.color = this.color;
        return clone;
    }

    public void deepMove(long dTick) {
        double tick1 = this.lane.getProject().tickAtMicros(this.realStartTimeInMicros);
        this.realStartTimeInMicros = (long)this.lane.getProject().microsAtTick(tick1 + (double)dTick);
    }

    public long getStartTick() {
        return (long)this.lane.getProject().getTempoList().getTickAtTime((this.realStartTimeInMicros + this.envelope.tOn) / 1000000.0);
    }

    public long getEndTick() {
        return (long)this.lane.getProject().getTempoList().getTickAtTime((this.realStartTimeInMicros + this.envelope.tOff) / 1000000.0);
    }

    public double getDurationInSecs() {
        return (this.envelope.tOff - this.envelope.tOn) / 1000000.0;
    }

    public double getStartInSecs() {
        return (this.realStartTimeInMicros + this.envelope.tOn) / 1000000.0;
    }

    public double getEndInSecs() {
        return (this.realStartTimeInMicros + this.envelope.tOff) / 1000000.0;
    }

    public void commitEventsRemove() {
    }

    public void commitEventsAdd() {
        this.refreshEnvelope();
    }

    public void onLoad() throws FileNotFoundException {
        File clipFile = new File(this.audioDir, this.audioFileName);
        if (!clipFile.exists()) {
            try {
                System.err.println(" Missing audio file " + clipFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            clipFile = null;
        }
        this.createFileHandles(clipFile);
    }

    public AudioClipReader createClipReader() throws IOException {
        File clipFile = new File(this.audioDir, this.audioFileName);
        FrinikaAudioServer server = FrinikaAudioSystem.getAudioServer();
        double fs = server.getSampleRate();
        return new AudioClipReader(clipFile, (long)(this.realStartTimeInMicros * fs / 1000000.0));
    }

    public AudioReader createAudioReader() throws IOException {
        File clipFile = new File(this.audioDir, this.audioFileName);
        VanillaRandomAccessFile rafG = new VanillaRandomAccessFile(new RandomAccessFile(clipFile, "r"));
        return new AudioReader(rafG);
    }

    public void attach() {
    }

    public void detach() {
    }

    private void reconstructThumbNail(Rectangle rect, PartView panel) {
        if (this.thumbNailRunnable == null) {
            this.thumbNailRunnable = new ThumbNailRunnable();
            Thread t = new Thread(this.thumbNailRunnable);
            t.setPriority(1);
            this.thumbNailRunnable.setThread(t);
            t.start();
        }
        this.thumbNailRunnable.reconstruct(rect, panel);
    }

    public void drawThumbNail(Graphics2D g, Rectangle rect, PartView panel) {
        if (this.outputProcess == null || this.thumbNailIn == null) {
            return;
        }
        if (this.thumbNailImage == null || this.lastRect == null || rect.width != this.lastRect.width || rect.height != this.lastRect.height) {
            this.lastRect = (Rectangle)rect.clone();
            this.reconstructThumbNail(this.lastRect, panel);
        }
        g.setXORMode(Color.WHITE);
        g.drawImage(this.thumbNailImage, rect.x, rect.y, null);
        g.setPaintMode();
    }

    public void moveContentsBy(double dTick, Lane dstLane) {
        double tick1 = this.lane.getProject().tickAtMicros(this.realStartTimeInMicros);
        this.realStartTimeInMicros = (long)this.lane.getProject().microsAtTick(tick1 + dTick);
        if (dstLane != this.lane) {
            this.lane.getParts().remove(this);
            dstLane.getParts().add(this);
            this.lane = dstLane;
        }
        this.outputProcess.setRealStartTime((long)this.realStartTimeInMicros);
    }

    public String toString() {
        String ret = this.hashCode() + ":" + this.audioDir + "/" + this.audioFileName + "|" + this.realStartTimeInMicros;
        return ret;
    }

    public AudioProcess getAudioProcess() {
        return this.outputProcess;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.init();
        in.defaultReadObject();
    }

    public void setStartTick(long tick) {
        this.envelope.setTOn(this.lane.getProject().microsAtTick(tick) - this.realStartTimeInMicros);
    }

    public void setEndTick(long tick) {
        this.envelope.setTOff(this.lane.getProject().microsAtTick(tick) - this.realStartTimeInMicros);
    }

    public void drawEnvelope(Graphics2D g, Rectangle rect, PartView view) {
        this.envelope.draw(g, rect, view);
    }

    public int getHoverState(Point p, Rectangle rect) {
        return this.envelope.getHoverState(p, rect);
    }

    public Envelope getEvelope() {
        return this.envelope;
    }

    protected void initContextMenu(ProjectFrame frame, JPopupMenu popup) {
        JMenuItem item = new JMenuItem(new AudioAnalysisAction(frame));
        popup.add(item);
    }

    public void setStartInSecs(double start) {
        this.envelope.setTOn(start * 1000000.0 - this.realStartTimeInMicros);
    }

    public void setEndInSecs(double end) {
        this.envelope.setTOff(1000000.0 * end - this.realStartTimeInMicros);
    }

    public final class Envelope
    implements Serializable {
        private static final long serialVersionUID = 1L;
        double tOn;
        double tRise;
        double gain = 1.0;
        double tOff;
        double tFall;
        transient double maxTime;

        public void validate() {
            assert (this.tOn <= this.tOff);
        }

        public double getGain() {
            return this.gain;
        }

        public void setGain(double gain) {
            System.out.println(" SET GAIN  " + gain);
            this.gain = gain > 1.0 ? 1.0 : (gain < 0.0 ? 0.0 : gain);
        }

        public double getTOff() {
            return this.tOff;
        }

        public void setTOff(double off1) {
            this.tOff = Math.min(off1, this.maxTime);
        }

        public double getTOn() {
            return this.tOn;
        }

        public void setTOn(double on1) {
            this.tOn = Math.max(0.0, on1);
        }

        public Object clone() {
            Envelope clone = new Envelope();
            clone.tOn = this.tOn;
            clone.tOff = this.tOff;
            clone.gain = this.gain;
            clone.tRise = this.tRise;
            clone.tFall = this.tFall;
            clone.maxTime = this.maxTime;
            return clone;
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
        }

        public double getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(double maxTime) {
            this.maxTime = maxTime;
        }

        public void draw(Graphics2D g, Rectangle rect, PartView view) {
            double xt = this.tOff - this.tOn;
            int x1 = rect.x;
            int y1 = rect.y + rect.height;
            int x4 = rect.x + rect.width;
            int y4 = y1;
            int x2 = (int)((double)x1 + this.tRise / xt * (double)rect.width);
            int y2 = (int)((double)rect.y + (double)rect.height * (1.0 - this.gain));
            int x3 = (int)((double)x4 - this.tFall / xt * (double)rect.width);
            int y3 = y2;
            Stroke stroke = g.getStroke();
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.BLUE);
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x2, y2, x3, y3);
            g.drawLine(x3, y3, x4, y4);
            g.setStroke(stroke);
            g.setColor(Color.YELLOW);
            anc.setLocation(x2 - danc, y2 - danc);
            g.fill(anc);
            anc.setLocation(x3 - danc, y3 - danc);
            g.fill(anc);
        }

        public int getHoverState(Point p, Rectangle rect) {
            int tol = 4;
            double xt = this.tOff - this.tOn;
            int y2 = (int)((double)rect.y + (1.0 - this.gain) * (double)rect.height);
            if (Math.abs(p.y - y2) > tol) {
                return -1;
            }
            int x1 = rect.x;
            int y1 = rect.y + rect.height;
            int x4 = rect.x + rect.width;
            int y4 = y1;
            int x2 = (int)((double)x1 + this.tRise / xt * (double)rect.width);
            if (Math.abs(p.x - x2 - tol) < tol) {
                return 5;
            }
            int x3 = (int)((double)x4 - this.tFall / xt * (double)rect.width);
            int y3 = y2;
            if (Math.abs(p.x - x3 + tol) < tol) {
                return 6;
            }
            return 7;
        }

        public void setTOffRel(double fact) {
            if (fact < 0.0 || fact > 1.0) {
                return;
            }
            this.tFall = (1.0 - fact) * (this.tOff - this.tOn);
        }

        public void setTOnRel(double fact) {
            if (fact < 0.0 || fact > 1.0) {
                return;
            }
            this.tRise = fact * (this.tOff - this.tOn);
        }

        public double getTFall() {
            return this.tFall;
        }

        public double getTRise() {
            return this.tRise;
        }

        public void setTFall(double fall) {
            this.tFall = fall;
        }

        public void setTRise(double rise) {
            this.tRise = rise;
        }
    }

    class ThumbNailRunnable
    implements Runnable {
        Rectangle rect;
        PartView panel;
        Thread runThread;
        Graphics2D gg;

        ThumbNailRunnable() {
        }

        public void reconstruct(Rectangle rect, PartView panel) {
            this.rect = rect;
            this.panel = panel;
            if (this.runThread.isInterrupted()) {
                return;
            }
            this.runThread.interrupt();
        }

        public void setThread(Thread t) {
            this.runThread = t;
        }

        synchronized boolean buildThumbNail() {
            AudioPart.this.thumbNailImage = new BufferedImage(this.rect.width, this.rect.height, 12);
            this.gg = (Graphics2D)AudioPart.this.thumbNailImage.getGraphics();
            int y = this.rect.height / 2;
            this.gg.drawString("...", 0, 5);
            this.panel.setDirty();
            double x = AudioPart.this.getStartInSecs();
            double w = AudioPart.this.getDurationInSecs();
            try {
                AudioPart.this.thumbNailIn.seekFrame(0L, false);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int nChannel = AudioPart.this.thumbNailIn.getFormat().getChannels();
            long nFrame = AudioPart.this.thumbNailIn.getLengthInFrames();
            ProjectContainer project = AudioPart.this.lane.getProject();
            double sampleToScreen = this.panel.userToScreen / (double)FrinikaConfig.sampleRate;
            int chunkSize = 1024;
            AudioBuffer buff = new AudioBuffer("thumbnail", nChannel, chunkSize, 44100.0f);
            int nRead = 0;
            double valMax = 0.0;
            double valMin = 0.0;
            double scale = (double)this.rect.height / 2.0;
            this.gg.setColor(Color.white);
            int midY = this.rect.height / 2;
            int pix = 0;
            int ii = 0;
            boolean cc = false;
            try {
                AudioPart.this.thumbNailIn.seekTimeInMicros(AudioPart.this.envelope.tOn, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            while ((long)nRead < nFrame) {
                float[] left;
                if (this.runThread.isInterrupted()) {
                    return false;
                }
                int nn = chunkSize;
                if ((long)(nRead + chunkSize) > nFrame) {
                    nn = (int)(nFrame - (long)nRead);
                }
                buff.makeSilence();
                AudioPart.this.thumbNailIn.processAudio(buff);
                nRead += nn;
                if (nChannel == 2) {
                    left = buff.getChannel(0);
                    float[] right = buff.getChannel(1);
                    int i = 0;
                    while (i < nn) {
                        float sampleL = left[i];
                        float sampleR = right[i];
                        valMin = Math.min(Math.min(valMin, (double)sampleL), (double)sampleR);
                        valMax = Math.max(Math.max(valMax, (double)sampleL), (double)sampleR);
                        int pixNow = (int)((double)ii * sampleToScreen);
                        if (pixNow > pix) {
                            this.gg.drawLine(pix, (int)((double)midY + valMin * scale), pix, (int)((double)midY + valMax * scale));
                            pix = pixNow;
                            valMin = 0.0;
                            valMax = 0.0;
                        }
                        ++i;
                        ++ii;
                    }
                    continue;
                }
                left = buff.getChannel(0);
                int i = 0;
                while (i < nn) {
                    float sampleL = left[i];
                    valMin = Math.min(valMin, (double)sampleL);
                    valMax = Math.max(valMax, (double)sampleL);
                    int pixNow = (int)((double)ii * sampleToScreen);
                    if (pixNow > pix) {
                        this.gg.drawLine(pix, (int)((double)midY + valMin * scale), pix, (int)((double)midY + valMax * scale));
                        pix = pixNow;
                        valMin = 0.0;
                        valMax = 0.0;
                    }
                    ++i;
                    ++ii;
                }
            }
            Rectangle2D brect = this.gg.getFontMetrics().getStringBounds(AudioPart.this.audioFileName, this.gg);
            this.gg.setColor(Color.BLACK);
            this.gg.fillRect(1, 0, (int)brect.getWidth(), (int)brect.getHeight());
            this.gg.setColor(Color.WHITE);
            this.gg.drawString(AudioPart.this.audioFileName, 1, (int)brect.getHeight());
            this.panel.setDirty();
            this.panel.repaint();
            return true;
        }

        public synchronized void run() {
            assert (this.runThread == Thread.currentThread());
            block2: while (true) {
                try {
                    while (true) {
                        this.wait();
                    }
                }
                catch (InterruptedException e1) {
                    while (true) {
                        if (this.buildThumbNail()) continue block2;
                        Thread.interrupted();
                    }
                }
                break;
            }
        }
    }
}

