/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.global.Toolbox;
import com.frinika.sequencer.midi.sysex.Sysex;
import com.frinika.sequencer.model.SysexMacro;
import java.util.StringTokenizer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;

public abstract class AbstractSysexMacro
implements SysexMacro {
    public static final String SYSEX_MACRO_PACKAGE = "com.frinika.sequencer.midi.sysex";

    public String usage() {
        return "Usage: <macro-name> <param1> <param2> ...";
    }

    public static SysexMacro findMacro(String s) {
        SysexMacro macro;
        String ww = Toolbox.firstWord(s);
        String w = Toolbox.capitalize(ww);
        try {
            Class<?> cl;
            try {
                cl = Class.forName("com.frinika.sequencer.midi.sysex." + w);
            }
            catch (ClassNotFoundException cnfe) {
                cl = Class.forName(ww);
            }
            Object o = cl.newInstance();
            macro = (SysexMacro)o;
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            return null;
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            try {
                byte b = AbstractSysexMacro.parseByte(w, 16);
            }
            catch (InvalidMidiDataException imde) {
                return null;
            }
            macro = new Sysex();
        }
        return macro;
    }

    public MidiMessage[] parseMessages(String macro) throws InvalidMidiDataException {
        byte[] data = this.parse(macro);
        SysexMessage syxm = new SysexMessage();
        syxm.setMessage(data, data.length);
        MidiMessage[] mm = new MidiMessage[]{syxm};
        return mm;
    }

    public byte[] parse(String macro) throws InvalidMidiDataException {
        StringTokenizer st = new StringTokenizer(macro);
        st.nextToken();
        return this.parse(st);
    }

    public byte[] parse(StringTokenizer st) throws InvalidMidiDataException {
        int size = st.countTokens();
        String[] args = new String[size];
        for (int i = 0; i < size; ++i) {
            args[i] = st.nextToken();
        }
        return this.parse(args);
    }

    public byte[] parse(String[] args) throws InvalidMidiDataException {
        int[] a = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            a[i] = this.parseIntArg(args[i], i);
        }
        return this.parse(a);
    }

    public int parseIntArg(String arg, int index) throws InvalidMidiDataException {
        return AbstractSysexMacro.parseInt(arg, 10);
    }

    public byte[] parse(int[] args) throws InvalidMidiDataException {
        throw new AbstractMethodError("parse(int[] args) or another parse-method must be implemented by sublcasses of SysexMacro");
    }

    public static String[] splitArgs(String s) {
        String[] w = Toolbox.splitWords(s);
        String[] args = new String[w.length - 1];
        System.arraycopy(w, 1, args, 0, args.length);
        return args;
    }

    protected static int parseInt(String s, int defaultRadix) throws InvalidMidiDataException {
        int radix = defaultRadix;
        if (s.startsWith("~")) {
            radix = 10;
            s = s.substring(1);
        } else if (s.startsWith("0x")) {
            radix = 16;
            s = s.substring(2);
        }
        try {
            return Integer.parseInt(s, radix);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidMidiDataException(nfe.getMessage());
        }
    }

    protected static int parseInt(String s, int defaultRadix, int min, int max) throws InvalidMidiDataException {
        int i = AbstractSysexMacro.parseInt(s, defaultRadix);
        if (i < min || i > max) {
            throw new InvalidMidiDataException("value " + i + " is not valid, expected range " + min + "..." + max);
        }
        return i;
    }

    protected static byte parseByte(String s, int defaultRadix) throws InvalidMidiDataException {
        int i = AbstractSysexMacro.parseInt(s, defaultRadix);
        if (i < 0 || i > 255) {
            throw new InvalidMidiDataException("value " + i + " is not a byte");
        }
        return (byte)i;
    }

    protected int parseType(String s, String[] list) throws InvalidMidiDataException {
        for (int i = 0; i < list.length; ++i) {
            if (!s.equalsIgnoreCase(list[i])) continue;
            return i;
        }
        throw new InvalidMidiDataException("Value '" + s + "' is not available in the list '" + Toolbox.joinStrings(list, ",") + "'.");
    }

    protected void error(String msg) throws InvalidMidiDataException {
        throw new InvalidMidiDataException(msg + "\n" + this.usage());
    }
}

