/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.tracker;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequence;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.sequencer.SwingSongPositionListenerWrapper;
import com.frinika.sequencer.gui.ItemRollToolBar;
import com.frinika.sequencer.gui.NoteLengthPopup;
import com.frinika.sequencer.gui.Snapable;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.gui.tracker.MultiEventCellEditor;
import com.frinika.sequencer.gui.tracker.TrackerTableModel;
import com.frinika.sequencer.gui.virtualkeyboard.VirtualKeyboard;
import com.frinika.sequencer.midi.MidiMessageListener;
import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.PitchBendEvent;
import com.frinika.sequencer.model.SysexEvent;
import com.frinika.tracker.DoubleCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerPanel
extends JPanel
implements SelectionListener<Part>,
SongPositionListener {
    private static final long serialVersionUID = 1L;
    ProjectFrame frame;
    ProjectContainer project;
    MidiPart part;
    int playingRow = 0;
    JTable table;
    TrackerTableModel tableModel;
    SelectionContainer<MultiEvent> multiEventSelectionContainer;
    private JScrollPane trackerScrollPane;
    private boolean followSong = true;
    private int automaticRowJump = 0;
    JComboBox octaveCombobox = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
    MidiMessageListener listener;
    MidiLane listenlane;
    Vector<Snapable> snapables;
    JButton quantizeSet;

    public TrackerPanel(FrinikaSequence sequence, ProjectFrame frame) {
        this.octaveCombobox.setSelectedItem(VirtualKeyboard.Octave);
        this.octaveCombobox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                VirtualKeyboard.Octave = (Integer)TrackerPanel.this.octaveCombobox.getSelectedItem();
            }
        });
        this.listener = new MidiMessageListener(){

            public void midiMessage(MidiMessage message) {
                MidiMessageRunnable r = new MidiMessageRunnable();
                r.message = message;
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        };
        this.listenlane = null;
        this.snapables = null;
        this.quantizeSet = null;
        this.frame = frame;
        this.project = frame.getProjectContainer();
        this.multiEventSelectionContainer = this.project.getMultiEventSelection();
        this.initComponents();
        this.project.getSequencer().addSongPositionListener(new SwingSongPositionListenerWrapper(this));
    }

    void connectMidiListener() {
        Lane lane;
        if (this.listenlane != null) {
            this.disconnectMidiListener();
        }
        if (!((lane = this.part.getLane()) instanceof MidiLane)) {
            return;
        }
        this.listenlane = (MidiLane)lane;
        this.project.getSequencer().addMidiMessageListener(this.listener);
    }

    void disconnectMidiListener() {
        if (this.listenlane == null) {
            return;
        }
        this.project.getSequencer().removeMidiMessageListener(this.listener);
    }

    void initComponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new TrackerTableModel(this.frame);
        this.table = new JTable(this.tableModel){
            private static final long serialVersionUID = 1L;
            JTable thistable;
            final DecimalFormat dec_format;
            final DecimalFormat dec_format2;
            TrackerTableCellRender renderer;
            {
                this.thistable = this;
                this.dec_format = new DecimalFormat("0.00");
                this.dec_format2 = new DecimalFormat("0.0");
                this.renderer = new TrackerTableCellRender();
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int firstcolsize = this.getColumnModel().getColumn(0).getWidth();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    int y = this.getRowHeight() * i;
                    g.setColor(Color.LIGHT_GRAY);
                    g.drawLine(0, y - 1, firstcolsize, y - 1);
                    if (i % TrackerPanel.this.tableModel.getTicksPerRow() != 0) continue;
                    g.setColor(Color.BLACK);
                    g.drawLine(0, y - 1, firstcolsize, y - 1);
                    if (i % (TrackerPanel.this.tableModel.getTicksPerRow() * 4) == 0) {
                        g.setColor(Color.BLACK);
                    } else {
                        g.setColor(Color.LIGHT_GRAY);
                    }
                    g.drawLine(0, y - 1, this.getWidth(), y - 1);
                }
                g.setColor(Color.BLACK);
                int x = 0;
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    if ((i - 1) % TrackerTableModel.COLUMNS == 0) {
                        g.drawLine(x - 1, 0, x - 1, this.getHeight());
                    }
                    x += this.getColumnModel().getColumn(i).getWidth();
                }
            }

            public void repaint(long tm, int x, int y, int width, int height) {
                Rectangle v = this.getVisibleRect();
                x = v.x;
                width = this.getVisibleRect().width;
                super.repaint(tm, x, y, width, height);
            }

            public void repaint(Rectangle r) {
                Rectangle v = this.getVisibleRect();
                r.x = v.x;
                r.width = v.width;
                super.repaint(r);
            }

            public boolean isColumnSelected(int column) {
                if (column == 0) {
                    return false;
                }
                int c = column - 1;
                c -= c % 4;
                if (this.columnModel.getSelectionModel().isSelectedIndex(c + 1)) {
                    return true;
                }
                if (this.columnModel.getSelectionModel().isSelectedIndex(c + 2)) {
                    return true;
                }
                if (this.columnModel.getSelectionModel().isSelectedIndex(c + 3)) {
                    return true;
                }
                return this.columnModel.getSelectionModel().isSelectedIndex(c + 4);
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                return this.renderer;
            }

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (column == 0 && row == TrackerPanel.this.playingRow) {
                    c.setBackground(Color.GREEN);
                } else if (c.getBackground() != null && c.getBackground().equals(Color.GREEN)) {
                    c.setBackground(null);
                }
                return c;
            }

            public void addColumn(TableColumn column) {
                if (this.getColumnCount() == 0) {
                    column.setPreferredWidth(60);
                } else {
                    switch ((this.getColumnCount() - 1) % TrackerTableModel.COLUMNS) {
                        case 0: {
                            column.setPreferredWidth(40);
                            column.setCellRenderer(new DoubleCellRenderer());
                            break;
                        }
                        case -1: {
                            column.setPreferredWidth(30);
                            break;
                        }
                        case 1: {
                            column.setPreferredWidth(40);
                            column.setCellEditor(new MultiEventCellEditor(TrackerPanel.this));
                            break;
                        }
                        case 2: {
                            column.setPreferredWidth(30);
                            break;
                        }
                        case 3: {
                            column.setPreferredWidth(40);
                            column.setCellRenderer(new DoubleCellRenderer());
                        }
                    }
                }
                super.addColumn(column);
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() >= 112 && e.getKeyCode() <= 120) {
                    VirtualKeyboard.Octave = e.getKeyCode() - 112 + 1;
                    TrackerPanel.this.octaveCombobox.setSelectedItem(VirtualKeyboard.Octave);
                    return true;
                }
                if (e.getKeyCode() == 8 && e.isShiftDown() && this.getSelectedRow() != -1 && this.getSelectedColumn() > 0) {
                    if (!pressed) {
                        return false;
                    }
                    if (this.getSelectedRow() != 0) {
                        this.setRowSelectionInterval(this.getSelectedRow() - 1, this.getSelectedRow() - 1);
                    }
                    ArrayList<Integer> cols = new ArrayList<Integer>();
                    for (int c : this.getSelectedColumns()) {
                        int col = TrackerPanel.this.tableModel.tableColumnToTrackerColumn(c);
                        if (cols.contains(col)) continue;
                        cols.add(col);
                    }
                    TrackerPanel.this.part.getEditHistoryContainer().mark("move events");
                    int min_row = this.getSelectedRow();
                    int max_row = this.getRowCount();
                    Iterator i$ = cols.iterator();
                    while (i$.hasNext()) {
                        int col = (Integer)i$.next();
                        for (int i = min_row; i < max_row; ++i) {
                            MultiEvent me = TrackerPanel.this.tableModel.getCellEvent(i, col);
                            if (me == null) continue;
                            TrackerPanel.this.part.remove(me);
                            if (i == min_row) continue;
                            me.setTrackerColumn(col);
                            me.setStartTick(TrackerPanel.this.tableModel.getTickForRow(i - 1));
                            TrackerPanel.this.part.add(me);
                        }
                    }
                    TrackerPanel.this.part.getEditHistoryContainer().notifyEditHistoryListeners();
                    return true;
                }
                if (e.getKeyCode() == 155 && this.getSelectedRow() != -1 && this.getSelectedColumn() > 0) {
                    if (!pressed) {
                        return false;
                    }
                    ArrayList<Integer> cols = new ArrayList<Integer>();
                    for (int c : this.getSelectedColumns()) {
                        int col = TrackerPanel.this.tableModel.tableColumnToTrackerColumn(c);
                        if (cols.contains(col)) continue;
                        cols.add(col);
                    }
                    TrackerPanel.this.part.getEditHistoryContainer().mark("move events");
                    int min_row = this.getSelectedRow();
                    Iterator i$ = cols.iterator();
                    while (i$.hasNext()) {
                        int col = (Integer)i$.next();
                        for (int i = this.getRowCount() - 1; i >= min_row; --i) {
                            MultiEvent me = TrackerPanel.this.tableModel.getCellEvent(i, col);
                            if (me == null) continue;
                            TrackerPanel.this.part.remove(me);
                            me.setTrackerColumn(col);
                            me.setStartTick(TrackerPanel.this.tableModel.getTickForRow(i + 1));
                            TrackerPanel.this.part.add(me);
                        }
                    }
                    TrackerPanel.this.part.getEditHistoryContainer().notifyEditHistoryListeners();
                    if (this.getSelectedRow() < this.getRowCount() - 1) {
                        this.setRowSelectionInterval(this.getSelectedRow() + 1, this.getSelectedRow() + 1);
                    }
                    return true;
                }
                if (e.getKeyCode() == 127) {
                    if (this.getSelectedColumnCount() > 1) {
                        return false;
                    }
                    if (this.getSelectedRowCount() > 1) {
                        return false;
                    }
                    if (this.getSelectedRow() != -1 && TrackerPanel.this.table.getSelectedColumn() > 0) {
                        if (!pressed) {
                            return false;
                        }
                        int col = TrackerPanel.this.tableModel.tableColumnToTrackerColumn(TrackerPanel.this.table.getSelectedColumn());
                        MultiEvent me = TrackerPanel.this.tableModel.getCellEvent(this.getSelectedRow(), col);
                        if (me != null) {
                            if (me instanceof NoteEvent) {
                                TrackerPanel.this.part.getEditHistoryContainer().mark("delete note");
                            } else if (me instanceof ControllerEvent) {
                                TrackerPanel.this.part.getEditHistoryContainer().mark("delete control change");
                            } else if (me instanceof PitchBendEvent) {
                                TrackerPanel.this.part.getEditHistoryContainer().mark("delete pitch bend");
                            } else if (me instanceof SysexEvent) {
                                TrackerPanel.this.part.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.sysex.delete_sysex"));
                            } else {
                                TrackerPanel.this.part.getEditHistoryContainer().mark("delete event");
                            }
                            TrackerPanel.this.part.remove(me);
                            TrackerPanel.this.part.getEditHistoryContainer().notifyEditHistoryListeners();
                        }
                        if (TrackerPanel.this.getAutomaticRowJump() > 0) {
                            TrackerPanel.this.table.changeSelection(TrackerPanel.this.table.getSelectedRow() + TrackerPanel.this.getAutomaticRowJump(), TrackerPanel.this.table.getSelectedColumn(), false, false);
                        }
                        return true;
                    }
                }
                if (TrackerPanel.this.isAccelerator(ks)) {
                    return false;
                }
                if (e.isControlDown() && ks.getKeyCode() == 37 && pressed && condition == 1) {
                    TrackerTableModel cfr_ignored_0 = TrackerPanel.this.tableModel;
                    if (this.getSelectedColumn() - TrackerTableModel.COLUMNS > 0) {
                        TrackerTableModel cfr_ignored_1 = TrackerPanel.this.tableModel;
                        this.changeSelection(this.getSelectedRow(), this.getSelectedColumn() - TrackerTableModel.COLUMNS, false, false);
                    }
                    return false;
                }
                if (e.isControlDown() && ks.getKeyCode() == 39 && pressed && condition == 1) {
                    TrackerTableModel cfr_ignored_2 = TrackerPanel.this.tableModel;
                    if (this.getSelectedColumn() + TrackerTableModel.COLUMNS < TrackerPanel.this.tableModel.getColumnCount()) {
                        TrackerTableModel cfr_ignored_3 = TrackerPanel.this.tableModel;
                        this.changeSelection(this.getSelectedRow(), this.getSelectedColumn() + TrackerTableModel.COLUMNS, false, false);
                    }
                    return false;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            public void tableChanged(TableModelEvent e) {
                if (e.getFirstRow() == -1) {
                    int selectedCol = this.getSelectedColumn();
                    int selectedRow = this.getSelectedRow();
                    super.tableChanged(e);
                    this.changeSelection(selectedRow, selectedCol, false, false);
                } else {
                    super.tableChanged(e);
                }
            }

            class TrackerTableCellRender
            extends DefaultTableCellRenderer {
                private static final long serialVersionUID = 1L;
                Color note_background = null;
                Color row_background = null;
                Color row_background2 = null;
                Font def_font = null;
                Font note_font = null;

                TrackerTableCellRender() {
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    float[] rgb;
                    boolean hasFocusOrg = hasFocus;
                    if (this.note_background == null) {
                        rgb = this.getGridColor().getRGBComponents(new float[4]);
                        rgb[0] = 1.0f - (1.0f - rgb[0]) * 0.4f;
                        rgb[1] = 1.0f - (1.0f - rgb[1]) * 0.4f;
                        rgb[2] = 1.0f - (1.0f - rgb[2]) * 0.4f;
                        this.note_background = new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
                        this.def_font = this.getFont();
                        this.note_font = this.def_font.deriveFont(1);
                    }
                    if (this.row_background == null) {
                        rgb = table.getSelectionBackground().getRGBComponents(new float[4]);
                        this.row_background = new Color(rgb[0], rgb[1], rgb[2], 0.2f);
                    }
                    if (this.row_background2 == null) {
                        rgb = table.getSelectionBackground().getRGBComponents(new float[4]);
                        this.row_background2 = new Color(rgb[0], rgb[1], rgb[2], 0.35f);
                    }
                    if (column == 0) {
                        isSelected = false;
                        hasFocus = false;
                    }
                    if (hasFocus) {
                        isSelected = false;
                    }
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (hasFocus) {
                        isSelected = false;
                        hasFocus = false;
                    }
                    if (!isSelected && !hasFocus) {
                        this.setBackground(thistable.getBackground());
                        if (column == 0) {
                            this.setBackground(this.getGridColor());
                        }
                        if ((column - 1) % TrackerTableModel.COLUMNS == 1) {
                            this.setBackground(this.note_background);
                        }
                    }
                    if ((column - 1) % TrackerTableModel.COLUMNS == 1) {
                        this.setFont(this.note_font);
                        this.setHorizontalAlignment(0);
                    } else {
                        this.setFont(this.def_font);
                        this.setHorizontalAlignment(4);
                    }
                    if (value instanceof Double) {
                        this.setText(dec_format.format((Double)value));
                    }
                    if (column == 0 && value.toString().length() != 0) {
                        this.setText(dec_format2.format(Double.parseDouble(value.toString())));
                    }
                    if (column != 0 && !isSelected && !hasFocus && row == this.getSelectionModel().getLeadSelectionIndex()) {
                        this.setOpaque(true);
                        if (hasFocusOrg) {
                            this.setBackground(this.row_background2);
                        } else {
                            this.setBackground(this.row_background);
                        }
                    }
                    return this;
                }
            }
        };
        this.table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TrackerPanel.this.connectMidiListener();
            }

            public void focusLost(FocusEvent e) {
                TrackerPanel.this.disconnectMidiListener();
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TrackerPanel.this.updateSelection();
                }
            }
        });
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TrackerPanel.this.updateSelection();
                }
            }
        });
        this.trackerScrollPane = new JScrollPane(this.table);
        this.add((Component)this.trackerScrollPane, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout());
        controlPanel.setOpaque(false);
        controlPanel.add(new JLabel("Octave"));
        controlPanel.add(this.octaveCombobox);
        String[] automaticRowJumpTextField_values = new String[]{"0", "1", "2", "3", "4", "8", "16"};
        final JComboBox<String> automaticRowJumpTextField = new JComboBox<String>(automaticRowJumpTextField_values);
        automaticRowJumpTextField.setEditable(true);
        automaticRowJumpTextField.setSelectedItem("" + this.automaticRowJump);
        automaticRowJumpTextField.setToolTipText(CurrentLocale.getMessage("sequencer.tracker.automaticrowjump.tooltip"));
        automaticRowJumpTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TrackerPanel.this.automaticRowJump = Integer.parseInt(automaticRowJumpTextField.getSelectedItem().toString());
                }
                catch (Exception ex) {
                    automaticRowJumpTextField.setSelectedItem(TrackerPanel.this.automaticRowJump + "");
                }
            }
        });
        controlPanel.add(new JLabel(CurrentLocale.getMessage("sequencer.tracker.automaticrowjump")));
        controlPanel.add(automaticRowJumpTextField);
        String[] editVelocityTextField_values = new String[]{"16", "32", "48", "64", "80", "100", "127"};
        final JComboBox<String> editVelocityTextField = new JComboBox<String>(editVelocityTextField_values);
        editVelocityTextField.setEditable(true);
        editVelocityTextField.setSelectedItem("" + this.tableModel.getEditVelocity());
        editVelocityTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TrackerPanel.this.tableModel.setEditVelocity(Integer.parseInt(editVelocityTextField.getSelectedItem().toString()));
                }
                catch (Exception ex) {
                    editVelocityTextField.setSelectedItem(TrackerPanel.this.tableModel.getEditVelocity() + "");
                }
            }
        });
        controlPanel.add(new JLabel(CurrentLocale.getMessage("sequencer.tracker.editvelocity")));
        controlPanel.add(editVelocityTextField);
        final DecimalFormat dec_format = new DecimalFormat("0.00");
        String[] editLenTextField_values = new String[]{dec_format.format(0.25), dec_format.format(0.5), dec_format.format(1L), dec_format.format(2L), dec_format.format(3L), dec_format.format(4L), dec_format.format(6L), dec_format.format(8L), dec_format.format(12L), dec_format.format(16L), dec_format.format(24L), dec_format.format(32L)};
        final JComboBox<String> editLenTextField = new JComboBox<String>(editLenTextField_values);
        editLenTextField.setEditable(true);
        editLenTextField.setSelectedItem(dec_format.format(this.tableModel.getEditDuration()));
        editLenTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TrackerPanel.this.tableModel.setEditDuration(dec_format.parse(editLenTextField.getSelectedItem().toString()).doubleValue());
                }
                catch (Exception ex) {
                    editLenTextField.setSelectedItem(dec_format.format(TrackerPanel.this.tableModel.getEditDuration()));
                }
            }
        });
        controlPanel.add(new JLabel("Edit Length"));
        controlPanel.add(editLenTextField);
        String[] rowsPerBeatTextField_values = new String[]{"1", "2", "3", "4", "6", "8"};
        final JComboBox<String> rowsPerBeatTextField = new JComboBox<String>(rowsPerBeatTextField_values);
        rowsPerBeatTextField.setSelectedItem("" + this.tableModel.getTicksPerRow());
        rowsPerBeatTextField.setEditable(true);
        rowsPerBeatTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TrackerPanel.this.tableModel.setRowsPerBeat(Integer.parseInt(rowsPerBeatTextField.getSelectedItem().toString()));
                    NoteLengthPopup.updateButton(TrackerPanel.this.quantizeSet, TrackerPanel.this.snapables, TrackerPanel.this.project.getSequence());
                }
                catch (Exception ex) {
                    rowsPerBeatTextField.setSelectedItem(TrackerPanel.this.tableModel.getTicksPerRow() + "");
                }
            }
        });
        controlPanel.add(new JLabel(CurrentLocale.getMessage("sequencer.tracker.rowsperbeat")));
        controlPanel.add(rowsPerBeatTextField);
        JPanel settings = new JPanel(new FlowLayout(1, 0, 0));
        final JToggleButton follow = ItemRollToolBar.makeFollowSongButton(null, settings);
        follow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrackerPanel.this.followSong = follow.isSelected();
            }
        });
        follow.setSelected(this.followSong);
        Insets insets = new Insets(0, 0, 0, 0);
        follow.setMargin(insets);
        this.snapables = new Vector();
        this.snapables.add(new Snapable(){

            public double getSnapQuantization() {
                return (double)TrackerPanel.this.project.getSequence().getResolution() / (double)TrackerPanel.this.tableModel.getTicksPerRow();
            }

            public void setSnapQuantization(double quant) {
                int rowsPerBeat = (int)((double)TrackerPanel.this.project.getSequence().getResolution() / quant);
                if (rowsPerBeat <= 0) {
                    rowsPerBeat = 1;
                }
                TrackerPanel.this.tableModel.setRowsPerBeat(rowsPerBeat);
                rowsPerBeatTextField.setSelectedItem("" + rowsPerBeat);
            }
        });
        this.quantizeSet = ItemRollToolBar.makeSnapToButton(this.snapables, settings, this.project.getSequence());
        this.quantizeSet.setMargin(insets);
        controlPanel.add(settings);
        JToolBar toolbar = new JToolBar();
        toolbar.add(controlPanel);
        this.add((Component)toolbar, "North");
    }

    private void updateSelection() {
        this.multiEventSelectionContainer.clearSelection();
        this.multiEventSelectionContainer.setSelectionStartTick(this.tableModel.getTickForRow(this.table.getSelectedRow()));
        this.multiEventSelectionContainer.setSelectionLeftColumn(this.tableModel.tableColumnToTrackerColumn(this.table.getSelectedColumn()));
        for (int row : this.table.getSelectedRows()) {
            int lasttrack = -1;
            for (int col : this.table.getSelectedColumns()) {
                int track;
                if (col == 0 || lasttrack == (track = (col - 1) / TrackerTableModel.COLUMNS)) continue;
                lasttrack = track;
                MultiEvent selectedEvt = this.tableModel.getMultiEventAt(row, col);
                if (selectedEvt == null) continue;
                this.multiEventSelectionContainer.addSelected(selectedEvt);
            }
        }
        this.multiEventSelectionContainer.notifyListeners();
    }

    public void dispose() {
        this.tableModel.dispose();
        this.project.getSequencer().removeSongPositionListener(this);
    }

    public MidiPart getPart() {
        return this.part;
    }

    public void setPart(MidiPart part) {
        if (part != this.part) {
            this.tableModel.setMidiPart(part);
            this.part = part;
        }
    }

    public void partSelectionCleared() {
    }

    public void partsRemovedFromSelection(Collection<Part> parts) {
    }

    void setPartToFocus() {
        Part focus = (Part)this.project.getPartSelection().getFocus();
        if (focus instanceof MidiPart) {
            this.setPart((MidiPart)focus);
        } else {
            this.setPart(null);
        }
    }

    @Override
    public void selectionChanged(SelectionContainer<? extends Part> src) {
        this.setPartToFocus();
    }

    @Override
    public void notifyTickPosition(long tick) {
        int lastPlayingRow = this.playingRow;
        this.playingRow = this.tableModel.getPlayingRow();
        if (this.playingRow != lastPlayingRow) {
            if (lastPlayingRow >= 0 && lastPlayingRow < this.table.getRowCount()) {
                this.tableModel.fireTableCellUpdated(lastPlayingRow, 0);
            }
            if (this.playingRow >= 0 && this.playingRow < this.tableModel.getRowCount()) {
                this.tableModel.fireTableCellUpdated(this.playingRow, 0);
            }
            if (this.followSong && this.playingRow >= 0 && this.playingRow < this.tableModel.getRowCount()) {
                Rectangle playRowRect = this.table.getCellRect(this.playingRow, 0, true);
                if (!this.trackerScrollPane.getViewport().getViewRect().intersects(this.table.getCellRect(this.playingRow, 0, true))) {
                    this.trackerScrollPane.getViewport().setViewPosition(new Point(playRowRect.x, playRowRect.y));
                    this.table.repaint();
                }
            }
        }
    }

    @Override
    public boolean requiresNotificationOnEachTick() {
        return false;
    }

    public JTable getTable() {
        return this.table;
    }

    public TrackerTableModel getTableModel() {
        return this.tableModel;
    }

    public int getAutomaticRowJump() {
        return this.automaticRowJump;
    }

    private boolean isAccelerator(KeyStroke ks) {
        return ks.equals(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    private class MidiMessageRunnable
    implements Runnable {
        MidiMessage message;

        private MidiMessageRunnable() {
        }

        public void run() {
            this.midiMessage(this.message);
        }

        public void midiMessage(MidiMessage message) {
            if (TrackerPanel.this.listenlane.isRecording()) {
                ShortMessage sms;
                if (TrackerPanel.this.table.getSelectedRow() == -1 || TrackerPanel.this.table.getSelectedColumn() == -1) {
                    return;
                }
                if ((TrackerPanel.this.table.getSelectedColumn() - 1) % TrackerTableModel.COLUMNS != 1) {
                    return;
                }
                if (message instanceof ShortMessage && ((sms = (ShortMessage)message).getCommand() == 144 || sms.getCommand() == 128)) {
                    int note = sms.getData1();
                    int vel = sms.getData2();
                    if (sms.getCommand() == 128) {
                        vel = 0;
                    }
                    if (vel > 0) {
                        int row = TrackerPanel.this.table.getSelectedRow();
                        int col = TrackerPanel.this.tableModel.tableColumnToTrackerColumn(TrackerPanel.this.table.getSelectedColumn());
                        TrackerPanel.this.part.getEditHistoryContainer().mark("new note");
                        MultiEvent me = TrackerPanel.this.tableModel.getCellEvent(row, col);
                        if (me != null) {
                            TrackerPanel.this.part.remove(me);
                        }
                        NoteEvent event = new NoteEvent(TrackerPanel.this.part, TrackerPanel.this.tableModel.getTickForRow(row), note, vel, 1, (long)(TrackerPanel.this.tableModel.ticksPerRow * TrackerPanel.this.tableModel.getEditDuration()));
                        event.setTrackerColumn(col);
                        TrackerPanel.this.part.add(event);
                        TrackerPanel.this.part.getEditHistoryContainer().notifyEditHistoryListeners();
                        if (TrackerPanel.this.getAutomaticRowJump() > 0) {
                            TrackerPanel.this.table.changeSelection(TrackerPanel.this.table.getSelectedRow() + TrackerPanel.this.getAutomaticRowJump(), TrackerPanel.this.table.getSelectedColumn(), false, false);
                        }
                    }
                }
            }
        }
    }
}

